/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.component.deployers.DefaultBindingsConfigurationProcessor;
import org.jboss.as.ee.subsystem.DefaultBindingsAdd;
import org.jboss.as.ee.subsystem.EESubsystemModel;
import org.jboss.as.ee.subsystem.EeExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DefaultBindingsResourceDefinition
extends SimpleResourceDefinition {
    public static final String CONTEXT_SERVICE = "context-service";
    public static final String DATASOURCE = "datasource";
    public static final String JMS_CONNECTION_FACTORY = "jms-connection-factory";
    public static final String MANAGED_EXECUTOR_SERVICE = "managed-executor-service";
    public static final String MANAGED_SCHEDULED_EXECUTOR_SERVICE = "managed-scheduled-executor-service";
    public static final String MANAGED_THREAD_FACTORY = "managed-thread-factory";
    public static final SimpleAttributeDefinition CONTEXT_SERVICE_AD = new SimpleAttributeDefinitionBuilder("context-service", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition DATASOURCE_AD = new SimpleAttributeDefinitionBuilder("datasource", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition JMS_CONNECTION_FACTORY_AD = new SimpleAttributeDefinitionBuilder("jms-connection-factory", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition MANAGED_EXECUTOR_SERVICE_AD = new SimpleAttributeDefinitionBuilder("managed-executor-service", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition MANAGED_SCHEDULED_EXECUTOR_SERVICE_AD = new SimpleAttributeDefinitionBuilder("managed-scheduled-executor-service", ModelType.STRING, true).setAllowExpression(true).build();
    public static final SimpleAttributeDefinition MANAGED_THREAD_FACTORY_AD = new SimpleAttributeDefinitionBuilder("managed-thread-factory", ModelType.STRING, true).setAllowExpression(true).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{CONTEXT_SERVICE_AD, DATASOURCE_AD, JMS_CONNECTION_FACTORY_AD, MANAGED_EXECUTOR_SERVICE_AD, MANAGED_SCHEDULED_EXECUTOR_SERVICE_AD, MANAGED_THREAD_FACTORY_AD};
    private final DefaultBindingsConfigurationProcessor defaultBindingsConfigurationProcessor;

    public DefaultBindingsResourceDefinition(DefaultBindingsConfigurationProcessor defaultBindingsConfigurationProcessor) {
        super(EESubsystemModel.DEFAULT_BINDINGS_PATH, EeExtension.getResourceDescriptionResolver("default-bindings"), (OperationStepHandler)new DefaultBindingsAdd(defaultBindingsConfigurationProcessor), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
        this.defaultBindingsConfigurationProcessor = defaultBindingsConfigurationProcessor;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler writeHandler = new WriteAttributeHandler();
        for (SimpleAttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)writeHandler);
        }
    }

    private class WriteAttributeHandler
    extends AbstractWriteAttributeHandler<Void> {
        private WriteAttributeHandler() {
            super((AttributeDefinition[])ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            this.applyUpdateToDeploymentUnitProcessor(attributeName, newValue);
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            this.applyUpdateToDeploymentUnitProcessor(attributeName, valueToRestore);
        }

        private void applyUpdateToDeploymentUnitProcessor(String attributeName, ModelNode newValue) throws OperationFailedException {
            String attributeValue;
            String string = attributeValue = newValue.isDefined() ? newValue.asString() : null;
            if (DefaultBindingsResourceDefinition.CONTEXT_SERVICE.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setContextService(attributeValue);
            } else if (DefaultBindingsResourceDefinition.DATASOURCE.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setDataSource(attributeValue);
            } else if (DefaultBindingsResourceDefinition.JMS_CONNECTION_FACTORY.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setJmsConnectionFactory(attributeValue);
            } else if (DefaultBindingsResourceDefinition.MANAGED_EXECUTOR_SERVICE.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setManagedExecutorService(attributeValue);
            } else if (DefaultBindingsResourceDefinition.MANAGED_SCHEDULED_EXECUTOR_SERVICE.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setManagedScheduledExecutorService(attributeValue);
            } else if (DefaultBindingsResourceDefinition.MANAGED_THREAD_FACTORY.equals(attributeName)) {
                DefaultBindingsResourceDefinition.this.defaultBindingsConfigurationProcessor.setManagedThreadFactory(attributeValue);
            }
        }
    }
}

