/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.List;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;

public final class HibernateSearchIndexedFieldProvider
implements BooleShannonExpansion.IndexedFieldProvider {
    private final SearchIntegrator searchFactory;
    private final Class<?> entityClass;

    public HibernateSearchIndexedFieldProvider(SearchIntegrator searchFactory, Class<?> entityClass) {
        this.searchFactory = searchFactory;
        this.entityClass = entityClass;
    }

    public boolean isIndexed(List<String> propertyPath) {
        EntityIndexBinding entityIndexBinding = this.searchFactory.getIndexBinding(this.entityClass);
        if (entityIndexBinding == null) {
            return false;
        }
        TypeMetadata typeMetadata = entityIndexBinding.getDocumentBuilder().getMetadata();
        for (int i = 0; i < propertyPath.size() - 1; ++i) {
            if ((typeMetadata = this.getEmbeddedTypeMetadata(typeMetadata, propertyPath.get(i))) != null) continue;
            return false;
        }
        String last = propertyPath.get(propertyPath.size() - 1);
        return typeMetadata.getPropertyMetadataForProperty(last) != null || this.getEmbeddedTypeMetadata(typeMetadata, last) != null;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(TypeMetadata typeMetadata, String name) {
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            if (!embeddedTypeMetadata.getEmbeddedFieldName().equals(name)) continue;
            return embeddedTypeMetadata;
        }
        return null;
    }
}

