/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.BaseEmbeddedQuery;

public final class HybridQuery
extends BaseEmbeddedQuery {
    private final ObjectFilter objectFilter;
    private final Query baseQuery;

    public HybridQuery(QueryFactory queryFactory, AdvancedCache<?, ?> cache, String jpaQuery, ObjectFilter objectFilter, long startOffset, int maxResults, Query baseQuery) {
        super(queryFactory, cache, jpaQuery, objectFilter.getProjection(), startOffset, maxResults);
        this.objectFilter = objectFilter;
        this.baseQuery = baseQuery;
    }

    @Override
    protected Comparator<Comparable[]> getComparator() {
        return this.objectFilter.getComparator();
    }

    @Override
    protected CloseableIterator<ObjectFilter.FilterResult> getIterator() {
        final Iterator it = this.baseQuery.list().iterator();
        return new CloseableIterator<ObjectFilter.FilterResult>(){
            private ObjectFilter.FilterResult nextResult = null;
            private boolean ready = false;

            public void close() {
            }

            public boolean hasNext() {
                this.update();
                return this.nextResult != null;
            }

            public ObjectFilter.FilterResult next() {
                if (this.hasNext()) {
                    this.ready = false;
                    return this.nextResult;
                }
                throw new NoSuchElementException();
            }

            private void update() {
                if (!this.ready) {
                    if (it.hasNext()) {
                        Object next = it.next();
                        this.nextResult = HybridQuery.this.objectFilter.filter(next);
                    } else {
                        this.nextResult = null;
                    }
                    this.ready = true;
                }
            }
        };
    }

    @Override
    public String toString() {
        return "HybridQuery{jpaQuery=" + this.jpaQuery + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", baseQuery=" + this.baseQuery + '}';
    }
}

