/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanServer;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.RealmAuthorizationCallbackHandler;
import org.jboss.as.clustering.jgroups.RelayConfiguration;
import org.jboss.as.clustering.jgroups.RemoteSiteConfiguration;
import org.jboss.as.clustering.jgroups.SaslClientCallbackHandler;
import org.jboss.as.clustering.jgroups.SaslConfiguration;
import org.jboss.as.clustering.jgroups.TopologyAddressGenerator;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.SASL;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.Util;

public class JChannelFactory
implements ChannelFactory,
ChannelListener,
ProtocolStackConfigurator {
    private final ProtocolStackConfiguration configuration;
    private final Map<Channel, String> channels = Collections.synchronizedMap(new WeakHashMap());

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ServerEnvironment getServerEnvironment() {
        return this.configuration.getEnvironment();
    }

    @Override
    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(final String id) throws Exception {
        MBeanServer server;
        SaslConfiguration saslConfig;
        JChannel channel = new JChannel((ProtocolStackConfigurator)this);
        TP transport = channel.getProtocolStack().getTransport();
        if (transport.isSingleton()) {
            TP tP = transport;
            synchronized (tP) {
                this.init(transport);
            }
        } else {
            this.init(transport);
        }
        RelayConfiguration relayConfig = this.configuration.getRelay();
        if (relayConfig != null) {
            String localSite = relayConfig.getSiteName();
            List<RemoteSiteConfiguration> remoteSites = this.configuration.getRelay().getRemoteSites();
            ArrayList<String> sites = new ArrayList<String>(remoteSites.size() + 1);
            sites.add(localSite);
            HashMap<String, 1> bridges = new HashMap<String, 1>();
            for (final RemoteSiteConfiguration remoteSite : remoteSites) {
                String siteName = remoteSite.getName();
                sites.add(siteName);
                String cluster = remoteSite.getCluster();
                final String clusterName = cluster != null ? cluster : siteName;
                RelayConfig.BridgeConfig bridge = new RelayConfig.BridgeConfig(clusterName){

                    public JChannel createChannel() throws Exception {
                        return (JChannel)remoteSite.getChannelFactory().createChannel(id + "/" + clusterName);
                    }
                };
                bridges.put(clusterName, bridge);
            }
            Collections.sort(sites);
            RELAY2 relay = new RELAY2().site(localSite);
            for (int i = 0; i < sites.size(); i = (int)((short)(i + 1))) {
                String site = (String)sites.get(i);
                RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(site);
                relay.addSite(site, siteConfig);
                if (!site.equals(localSite)) continue;
                for (RelayConfig.BridgeConfig bridge : bridges.values()) {
                    siteConfig.addBridge(bridge);
                }
            }
            Configurator.resolveAndAssignFields((Object)relay, relayConfig.getProperties());
            Configurator.resolveAndInvokePropertyMethods((Object)relay, relayConfig.getProperties());
            channel.getProtocolStack().addProtocol((Protocol)relay);
            relay.init();
        }
        if ((saslConfig = this.configuration.getSasl()) != null) {
            String clusterRole = saslConfig.getClusterRole();
            SecurityRealm securityRealm = saslConfig.getSecurityRealm();
            String mech = saslConfig.getMech();
            SASL sasl = new SASL();
            sasl.setMech(mech);
            Map<String, String> props = saslConfig.getProperties();
            if (props.containsKey("client_password")) {
                String credential = props.get("client_password");
                String name = props.get("client_name");
                if (name == null) {
                    sasl.setClientCallbackHandler((CallbackHandler)new SaslClientCallbackHandler(securityRealm.getName(), this.configuration.getEnvironment().getNodeName(), credential));
                } else if (name.contains("@")) {
                    sasl.setClientCallbackHandler((CallbackHandler)new SaslClientCallbackHandler(name, credential));
                } else {
                    sasl.setClientCallbackHandler((CallbackHandler)new SaslClientCallbackHandler(securityRealm.getName(), name, credential));
                }
            } else {
                props.put("client_password", "");
            }
            HashMap<String, String> saslProps = props.containsKey("sasl_props") ? Util.parseCommaDelimitedProps((String)props.get("sasl_props")) : new HashMap<String, String>();
            sasl.setServerCallbackHandler((CallbackHandler)new RealmAuthorizationCallbackHandler(securityRealm, mech, clusterRole != null ? clusterRole : id, saslProps));
            props.put("sasl_props", new PropertyConverters.StringProperties().toString(saslProps));
            Configurator.resolveAndAssignFields((Object)sasl, props);
            Configurator.resolveAndInvokePropertyMethods((Object)sasl, props);
            channel.getProtocolStack().insertProtocol((Protocol)sasl, 2, GMS.class);
            sasl.init();
        }
        channel.setName(this.configuration.getEnvironment().getNodeName() + "/" + id);
        TransportConfiguration.Topology topology = this.configuration.getTransport().getTopology();
        if (topology != null) {
            channel.setAddressGenerator((AddressGenerator)new TopologyAddressGenerator((Channel)channel, topology.getSite(), topology.getRack(), topology.getMachine()));
        }
        if ((server = this.configuration.getMBeanServer()) != null) {
            try {
                this.channels.put((Channel)channel, id);
                JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)server, (String)id);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
            channel.addChannelListener((ChannelListener)this);
        }
        return channel;
    }

    private void init(TP transport) {
        SocketFactory factory;
        TransportConfiguration transportConfig = this.configuration.getTransport();
        SocketBinding binding = transportConfig.getSocketBinding();
        if (binding != null && !((factory = transport.getSocketFactory()) instanceof ManagedSocketFactory)) {
            transport.setSocketFactory((SocketFactory)new ManagedSocketFactory(factory, binding.getSocketBindings()));
        }
    }

    public String getProtocolStackString() {
        return null;
    }

    public List<org.jgroups.conf.ProtocolConfiguration> getProtocolStack() {
        SocketBinding diagnosticsSocketBinding;
        SocketBinding binding;
        ArrayList<org.jgroups.conf.ProtocolConfiguration> configs = new ArrayList<org.jgroups.conf.ProtocolConfiguration>(this.configuration.getProtocols().size() + 1);
        TransportConfiguration transport = this.configuration.getTransport();
        org.jgroups.conf.ProtocolConfiguration config = this.createProtocol(transport);
        Map properties = config.getProperties();
        if (transport.isShared()) {
            properties.put("singleton_name", this.configuration.getName());
        }
        if ((binding = transport.getSocketBinding()) != null) {
            this.configureBindAddress(transport, config, binding);
            this.configureServerSocket(transport, config, "bind_port", binding);
            this.configureMulticastSocket(transport, config, "mcast_addr", "mcast_port", binding);
        }
        boolean diagnostics = (diagnosticsSocketBinding = transport.getDiagnosticsSocketBinding()) != null;
        properties.put("enable_diagnostics", String.valueOf(diagnostics));
        if (diagnostics) {
            this.configureMulticastSocket(transport, config, "diagnostics_addr", "diagnostics_port", diagnosticsSocketBinding);
        }
        configs.add(config);
        boolean supportsMulticast = transport.hasProperty("mcast_addr");
        for (ProtocolConfiguration protocol : this.configuration.getProtocols()) {
            config = this.createProtocol(protocol);
            binding = protocol.getSocketBinding();
            if (binding != null) {
                this.configureBindAddress(protocol, config, binding);
                this.configureServerSocket(protocol, config, "bind_port", binding);
                this.configureServerSocket(protocol, config, "start_port", binding);
                this.configureMulticastSocket(protocol, config, "mcast_addr", "mcast_port", binding);
            } else if (transport.getSocketBinding() != null) {
                this.configureBindAddress(protocol, config, transport.getSocketBinding());
            }
            if (!supportsMulticast) {
                this.setProperty(protocol, config, "use_mcast_xmit", String.valueOf(false));
            }
            configs.add(config);
        }
        return configs;
    }

    private void configureBindAddress(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, SocketBinding binding) {
        this.setPropertyNoOverride(protocol, config, "bind_addr", binding.getSocketAddress().getAddress().getHostAddress());
    }

    private void configureServerSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String property, SocketBinding binding) {
        this.setPropertyNoOverride(protocol, config, property, String.valueOf(binding.getSocketAddress().getPort()));
    }

    private void configureMulticastSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String addressProperty, String portProperty, SocketBinding binding) {
        try {
            InetSocketAddress mcastSocketAddress = binding.getMulticastSocketAddress();
            this.setPropertyNoOverride(protocol, config, addressProperty, mcastSocketAddress.getAddress().getHostAddress());
            this.setPropertyNoOverride(protocol, config, portProperty, String.valueOf(mcastSocketAddress.getPort()));
        }
        catch (IllegalStateException e) {
            JGroupsLogger.ROOT_LOGGER.couldNotSetAddressAndPortNoMulticastSocket(e, config.getProtocolName(), addressProperty, config.getProtocolName(), portProperty, binding.getName());
        }
    }

    private void setPropertyNoOverride(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String name, String value) {
        boolean overridden = false;
        String propertyValue = null;
        try {
            overridden = config.getOriginalProperties().containsKey(name);
            if (overridden) {
                propertyValue = (String)config.getOriginalProperties().get(name);
            }
        }
        catch (Exception e) {
            JGroupsLogger.ROOT_LOGGER.unableToAccessProtocolPropertyValue(e, name, protocol.getName());
        }
        if (overridden) {
            JGroupsLogger.ROOT_LOGGER.unableToOverrideSocketBindingValue(name, protocol.getName(), value, propertyValue);
        }
        this.setProperty(protocol, config, name, value);
    }

    private void setProperty(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String name, String value) {
        if (protocol.hasProperty(name)) {
            config.getProperties().put(name, value);
        }
    }

    private org.jgroups.conf.ProtocolConfiguration createProtocol(ProtocolConfiguration protocolConfig) {
        String protocol = protocolConfig.getName();
        final HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getDefaults().getProperties(protocol));
        properties.putAll(protocolConfig.getProperties());
        return new org.jgroups.conf.ProtocolConfiguration(protocol, properties){

            public Map<String, String> getOriginalProperties() {
                return properties;
            }
        };
    }

    private void setValue(Protocol protocol, String property, Object value) {
        JGroupsLogger.ROOT_LOGGER.setProtocolPropertyValue(protocol.getName(), property, value);
        try {
            protocol.setValue(property, value);
        }
        catch (IllegalArgumentException e) {
            JGroupsLogger.ROOT_LOGGER.nonExistentProtocolPropertyValue(e, protocol.getName(), property, value);
        }
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)channel), (MBeanServer)server, (String)this.channels.remove(channel));
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
        }
    }
}

