/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ConsoleInputSession {
    private InputStream consoleStream;
    private InputStream externalInputStream;
    private ArrayBlockingQueue<String> blockingQueue = new ArrayBlockingQueue(1000);
    private volatile boolean connected;

    public ConsoleInputSession(InputStream consoleStream) {
        this.consoleStream = consoleStream;
        this.connected = true;
        this.externalInputStream = new InputStream(){
            private String b;
            private int c;

            @Override
            public int read() throws IOException {
                try {
                    if (this.b == null || this.c == this.b.length()) {
                        this.b = ConsoleInputSession.this.connected ? (String)ConsoleInputSession.this.blockingQueue.poll(365L, TimeUnit.DAYS) : (String)ConsoleInputSession.this.blockingQueue.poll();
                        this.c = 0;
                    }
                    if (this.b != null && !this.b.isEmpty()) {
                        return this.b.charAt(this.c++);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return -1;
            }

            @Override
            public int available() {
                if (this.b != null) {
                    return this.b.length();
                }
                return 0;
            }

            @Override
            public void close() throws IOException {
                ConsoleInputSession.this.stop();
            }
        };
        this.startReader();
    }

    private void startReader() {
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                byte[] bBuf = new byte[1024];
                try {
                    while (ConsoleInputSession.this.connected) {
                        int read = ConsoleInputSession.this.consoleStream.read(bBuf);
                        if (read > 0) {
                            ConsoleInputSession.this.blockingQueue.put(new String(bBuf, 0, read));
                        }
                        if (read != -1) continue;
                        ConsoleInputSession.this.connected = false;
                        ConsoleInputSession.this.blockingQueue.offer("");
                    }
                }
                catch (IOException e) {
                    if (ConsoleInputSession.this.connected) {
                        ConsoleInputSession.this.connected = false;
                        throw new RuntimeException("broken pipe");
                    }
                }
                catch (InterruptedException e) {
                    ConsoleInputSession.this.connected = false;
                }
            }
        };
        readerThread.setDaemon(true);
        readerThread.start();
    }

    public void interruptPipe() {
        this.blockingQueue.offer("\n");
    }

    public void stop() {
        this.connected = false;
        this.blockingQueue.offer("");
    }

    public InputStream getExternalInputStream() {
        return this.externalInputStream;
    }
}

