/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.deployments.ConverterFactoryExtensionProcessor;
import org.infinispan.server.endpoint.deployments.FilterConverterFactoryExtensionProcessor;
import org.infinispan.server.endpoint.deployments.FilterFactoryExtensionProcessor;
import org.infinispan.server.endpoint.deployments.KeyValueFilterConverterExtensionProcessor;
import org.infinispan.server.endpoint.deployments.MarshallerExtensionProcessor;
import org.infinispan.server.endpoint.deployments.ServerExtensionDependenciesProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

class EndpointSubsystemAdd
extends AbstractAddStepHandler {
    static final EndpointSubsystemAdd INSTANCE = new EndpointSubsystemAdd();
    private static final String[] CONNECTORS = new String[]{"hotrod-connector", "memcached-connector", "rest-connector"};

    EndpointSubsystemAdd() {
    }

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        EndpointSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        for (String connectorType : CONNECTORS) {
            target.get(connectorType).setEmptyObject();
        }
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        EndpointSubsystemAdd.populate(source, target);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    protected void performRuntime(OperationContext ctx, ModelNode operation, ModelNode model) throws OperationFailedException {
        final ServiceName serviceName = Constants.EXTENSION_MANAGER_NAME;
        ExtensionManagerService service = new ExtensionManagerService();
        ServiceBuilder builder = ctx.getServiceTarget().addService(serviceName, (Service)service);
        ctx.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("endpoint", Phase.INSTALL, 6145, (DeploymentUnitProcessor)new FilterFactoryExtensionProcessor(serviceName));
                processorTarget.addDeploymentProcessor("endpoint", Phase.INSTALL, 6146, (DeploymentUnitProcessor)new ConverterFactoryExtensionProcessor(serviceName));
                processorTarget.addDeploymentProcessor("endpoint", Phase.INSTALL, 6148, (DeploymentUnitProcessor)new FilterConverterFactoryExtensionProcessor(serviceName));
                processorTarget.addDeploymentProcessor("endpoint", Phase.INSTALL, 6149, (DeploymentUnitProcessor)new KeyValueFilterConverterExtensionProcessor(serviceName));
                processorTarget.addDeploymentProcessor("endpoint", Phase.INSTALL, 6147, (DeploymentUnitProcessor)new MarshallerExtensionProcessor(serviceName));
                processorTarget.addDeploymentProcessor("endpoint", Phase.DEPENDENCIES, 7169, (DeploymentUnitProcessor)new ServerExtensionDependenciesProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        builder.install();
    }
}

