/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;

public class Trust10
extends AbstractSecurityAssertion
implements PolicyContainingAssertion {
    private Policy nestedPolicy;
    private boolean mustSupportClientChallenge;
    private boolean mustSupportServerChallenge;
    private boolean requireClientEntropy;
    private boolean requireServerEntropy;
    private boolean mustSupportIssuedTokens;

    public Trust10(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version);
        this.nestedPolicy = nestedPolicy;
        this.parseNestedTrust10Policy(nestedPolicy, this);
    }

    public Policy getPolicy() {
        return this.nestedPolicy;
    }

    public QName getName() {
        return this.getVersion().getSPConstants().getTrust10();
    }

    @Override
    public PolicyComponent normalize() {
        return super.normalize(this.getPolicy());
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        super.serialize(writer, this.getPolicy());
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new Trust10(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedTrust10Policy(Policy nestedPolicy, Trust10 trust10) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (this.getVersion().getSPConstants().getMustSupportClientChallenge().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportClientChallenge().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust10.isMustSupportClientChallenge()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust10.setMustSupportClientChallenge(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getMustSupportServerChallenge().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getMustSupportServerChallenge().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust10.isMustSupportServerChallenge()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust10.setMustSupportServerChallenge(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireClientEntropy().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireClientEntropy().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust10.isRequireClientEntropy()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust10.setRequireClientEntropy(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireServerEntropy().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireServerEntropy().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust10.isRequireServerEntropy()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust10.setRequireServerEntropy(true);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getMustSupportIssuedTokens().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getMustSupportIssuedTokens().getNamespaceURI().equals(assertionNamespace)) continue;
                if (trust10.isMustSupportIssuedTokens()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                trust10.setMustSupportIssuedTokens(true);
            }
        }
    }

    public boolean isMustSupportClientChallenge() {
        return this.mustSupportClientChallenge;
    }

    protected void setMustSupportClientChallenge(boolean mustSupportClientChallenge) {
        this.mustSupportClientChallenge = mustSupportClientChallenge;
    }

    public boolean isMustSupportServerChallenge() {
        return this.mustSupportServerChallenge;
    }

    protected void setMustSupportServerChallenge(boolean mustSupportServerChallenge) {
        this.mustSupportServerChallenge = mustSupportServerChallenge;
    }

    public boolean isRequireClientEntropy() {
        return this.requireClientEntropy;
    }

    protected void setRequireClientEntropy(boolean requireClientEntropy) {
        this.requireClientEntropy = requireClientEntropy;
    }

    public boolean isRequireServerEntropy() {
        return this.requireServerEntropy;
    }

    protected void setRequireServerEntropy(boolean requireServerEntropy) {
        this.requireServerEntropy = requireServerEntropy;
    }

    public boolean isMustSupportIssuedTokens() {
        return this.mustSupportIssuedTokens;
    }

    protected void setMustSupportIssuedTokens(boolean mustSupportIssuedTokens) {
        this.mustSupportIssuedTokens = mustSupportIssuedTokens;
    }
}

