/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.Trust10;

public class Trust13
extends Trust10 {
    private boolean requireRequestSecurityTokenCollection;
    private boolean requireAppliesTo;
    private boolean scopePolicy15;
    private boolean mustSupportInteractiveChallenge;

    public Trust13(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version, nestedPolicy);
        this.parseNestedTrust13Policy(nestedPolicy, this);
    }

    @Override
    public QName getName() {
        return this.getVersion().getSPConstants().getTrust13();
    }

    @Override
    protected AbstractSecurityAssertion cloneAssertion(Policy nestedPolicy) {
        return new Trust13(this.getVersion(), nestedPolicy);
    }

    protected void parseNestedTrust13Policy(Policy nestedPolicy, Trust13 trust13) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                String assertionNamespace = assertion.getName().getNamespaceURI();
                if (this.getVersion().getSPConstants().getRequireRequestSecurityTokenCollection().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireRequestSecurityTokenCollection().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust13.isRequireRequestSecurityTokenCollection()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust13.setRequireRequestSecurityTokenCollection(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getRequireAppliesTo().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getRequireAppliesTo().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust13.isRequireAppliesTo()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust13.setRequireAppliesTo(true);
                    continue;
                }
                if (this.getVersion().getSPConstants().getScopePolicy15().getLocalPart().equals(assertionName) && this.getVersion().getSPConstants().getScopePolicy15().getNamespaceURI().equals(assertionNamespace)) {
                    if (trust13.isScopePolicy15()) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    trust13.setScopePolicy15(true);
                    continue;
                }
                if (!this.getVersion().getSPConstants().getMustSupportInteractiveChallenge().getLocalPart().equals(assertionName) || !this.getVersion().getSPConstants().getMustSupportInteractiveChallenge().getNamespaceURI().equals(assertionNamespace)) continue;
                if (trust13.isMustSupportInteractiveChallenge()) {
                    throw new IllegalArgumentException("Invalid Policy");
                }
                trust13.setMustSupportInteractiveChallenge(true);
            }
        }
    }

    public boolean isRequireRequestSecurityTokenCollection() {
        return this.requireRequestSecurityTokenCollection;
    }

    protected void setRequireRequestSecurityTokenCollection(boolean requireRequestSecurityTokenCollection) {
        this.requireRequestSecurityTokenCollection = requireRequestSecurityTokenCollection;
    }

    public boolean isRequireAppliesTo() {
        return this.requireAppliesTo;
    }

    protected void setRequireAppliesTo(boolean requireAppliesTo) {
        this.requireAppliesTo = requireAppliesTo;
    }

    public boolean isScopePolicy15() {
        return this.scopePolicy15;
    }

    protected void setScopePolicy15(boolean scopePolicy15) {
        this.scopePolicy15 = scopePolicy15;
    }

    public boolean isMustSupportInteractiveChallenge() {
        return this.mustSupportInteractiveChallenge;
    }

    protected void setMustSupportInteractiveChallenge(boolean mustSupportInteractiveChallenge) {
        this.mustSupportInteractiveChallenge = mustSupportInteractiveChallenge;
    }
}

