/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtils {
    private FileUtils() {
    }

    public static String readFile(Class<?> testClass, String fileName) {
        URL res = testClass.getResource(fileName);
        return FileUtils.readFile(res);
    }

    public static String readFile(URL url) {
        try {
            return FileUtils.readFile(url.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFile(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(InputStream file) {
        try (BufferedInputStream stream = new BufferedInputStream(file);){
            int read;
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileOrCheckParentsIfNotFound(String baseStr, String path) throws FileNotFoundException {
        File base = new File(baseStr);
        if (!base.exists()) {
            throw new FileNotFoundException("Base path not found: " + base.getPath());
        }
        File f = new File(base = base.getAbsoluteFile(), path);
        if (f.exists()) {
            return f;
        }
        File fLast = f;
        while (!f.exists()) {
            int slash = path.lastIndexOf(File.separatorChar);
            if (slash <= 0) {
                throw new FileNotFoundException("Path not found: " + f.getPath());
            }
            path = path.substring(0, slash);
            fLast = f;
            f = new File(base, path);
        }
        throw new FileNotFoundException("Path not found: " + fLast.getPath());
    }

    public static void copyFile(File src, File dest) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));){
            FileUtils.copyFile(in, dest);
        }
    }

    public static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));){
            int read;
            while ((read = in.read()) != -1) {
                ((OutputStream)out).write(read);
            }
        }
    }

    public static void deleteRecursive(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.deleteRecursive(f);
            }
        }
        file.delete();
    }
}

