/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.SimpleParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.ValidatingCallbackHandler;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.cli.parsing.operation.header.RolloutPlanHeaderCallbackHandler;
import org.jboss.dmr.ModelNode;

public class DefaultCallbackHandler
extends ValidatingCallbackHandler
implements ParsedCommandLine {
    private static final int SEPARATOR_NONE = 0;
    private static final int SEPARATOR_NODE_TYPE_NAME = 1;
    private static final int SEPARATOR_NODE = 2;
    private static final int SEPARATOR_ADDRESS_OPERATION = 3;
    private static final int SEPARATOR_OPERATION_ARGUMENTS = 4;
    private static final int SEPARATOR_ARG_NAME_VALUE = 5;
    private static final int SEPARATOR_ARG = 6;
    private static final int SEPARATOR_ARG_LIST_END = 7;
    private static final int SEPARATOR_HEADERS_START = 8;
    private static final int SEPARATOR_HEADER = 9;
    private static final DefaultOperationRequestAddress EMPTY_ADDRESS = new DefaultOperationRequestAddress();
    private int separator = 0;
    private int lastSeparatorIndex = -1;
    private int lastChunkIndex = 0;
    private boolean operationComplete;
    private String operationName;
    private OperationRequestAddress address;
    private boolean addressChanged;
    private Map<String, String> props = Collections.emptyMap();
    private List<String> otherArgs = Collections.emptyList();
    private String outputTarget;
    private String lastPropName;
    private String lastPropValue;
    private String lastHeaderName;
    private CommandLineFormat format;
    private boolean validation;
    private String originalLine;
    private String substitutedLine;
    private LinkedHashMap<String, ParsedOperationRequestHeader> headers;
    private ParsedOperationRequestHeader lastHeader;

    public DefaultCallbackHandler() {
        this(true);
    }

    public DefaultCallbackHandler(boolean validate) {
        this.validation = validate;
    }

    public DefaultCallbackHandler(OperationRequestAddress prefix) {
        this.address = prefix;
    }

    @Deprecated
    public void parse(OperationRequestAddress initialAddress, String argsStr) throws CommandFormatException {
        this.parse(initialAddress, argsStr, null);
    }

    public void parse(OperationRequestAddress initialAddress, String argsStr, CommandContext ctx) throws CommandFormatException {
        this.reset();
        if (initialAddress != null) {
            this.address = new DefaultOperationRequestAddress(initialAddress);
        }
        this.originalLine = argsStr;
        this.substitutedLine = ParserUtil.parse(argsStr, this, this.validation, ctx);
    }

    @Deprecated
    public void parse(OperationRequestAddress initialAddress, String argsStr, boolean validation) throws CommandFormatException {
        this.parse(initialAddress, argsStr, validation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(OperationRequestAddress initialAddress, String argsStr, boolean validation, CommandContext ctx) throws CommandFormatException {
        boolean defaultValidation = this.validation;
        this.validation = validation;
        try {
            this.parse(initialAddress, argsStr, ctx);
        }
        finally {
            this.validation = defaultValidation;
        }
    }

    public void parseOperation(OperationRequestAddress prefix, String argsStr) throws CommandFormatException {
        this.reset();
        this.setFormat(OperationFormat.INSTANCE);
        if (prefix != null) {
            this.address = new DefaultOperationRequestAddress(prefix);
        }
        this.setFormat(OperationFormat.INSTANCE);
        this.originalLine = argsStr;
        this.substitutedLine = ParserUtil.parseOperationRequest(argsStr, this);
    }

    public void parseHeaders(String argsStr) throws CommandFormatException {
        this.reset();
        this.originalLine = argsStr;
        this.substitutedLine = ParserUtil.parseHeaders(argsStr, this);
    }

    public void reset() {
        this.operationComplete = false;
        this.operationName = null;
        this.address = null;
        this.addressChanged = false;
        this.props = Collections.emptyMap();
        this.otherArgs = Collections.emptyList();
        this.outputTarget = null;
        this.lastPropName = null;
        this.lastPropValue = null;
        this.lastSeparatorIndex = -1;
        this.separator = 0;
        this.lastChunkIndex = 0;
        this.format = null;
        this.originalLine = null;
        this.substitutedLine = null;
        this.headers = null;
        this.lastHeaderName = null;
        this.lastHeader = null;
    }

    @Override
    public String getOriginalLine() {
        return this.originalLine;
    }

    @Override
    public String getSubstitutedLine() {
        return this.substitutedLine;
    }

    @Override
    public List<String> getOtherProperties() {
        return this.otherArgs;
    }

    @Override
    public boolean isRequestComplete() {
        return this.operationComplete;
    }

    @Override
    public boolean endsOnPropertySeparator() {
        return this.separator == 6;
    }

    @Override
    public boolean endsOnPropertyValueSeparator() {
        return this.separator == 5;
    }

    @Override
    public boolean endsOnPropertyListStart() {
        return this.separator == 4;
    }

    @Override
    public boolean endsOnPropertyListEnd() {
        return this.separator == 7;
    }

    @Override
    public boolean endsOnHeaderListStart() {
        return this.separator == 8;
    }

    @Override
    public boolean endsOnAddressOperationNameSeparator() {
        return this.separator == 3;
    }

    @Override
    public boolean endsOnNodeSeparator() {
        return this.separator == 2;
    }

    @Override
    public boolean endsOnNodeTypeNameSeparator() {
        return this.separator == 1;
    }

    @Override
    public boolean endsOnSeparator() {
        return this.separator != 0;
    }

    @Override
    public boolean hasAddress() {
        return this.address != null;
    }

    @Override
    public OperationRequestAddress getAddress() {
        return this.address == null ? EMPTY_ADDRESS : this.address;
    }

    @Override
    public boolean hasOperationName() {
        return this.operationName != null;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    @Override
    public boolean hasProperties() {
        return !this.props.isEmpty() || !this.otherArgs.isEmpty();
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.props.containsKey(propertyName);
    }

    @Override
    public void validatedNodeType(int index, String nodeType) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        } else if (this.address.endsOnType()) {
            throw new OperationFormatException("Can't proceed with node type '" + nodeType + "' until the node name for the previous node type has been specified.");
        }
        this.address.toNodeType(nodeType);
        this.separator = 0;
        this.lastChunkIndex = index;
    }

    @Override
    public void nodeTypeNameSeparator(int index) {
        this.separator = 1;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void validatedNodeName(int index, String nodeName) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        }
        if (!this.address.endsOnType()) {
            throw new OperationFormatException("Node path format is wrong around '" + nodeName + "' (index=" + index + ").");
        }
        this.address.toNode(nodeName);
        this.separator = 0;
        this.lastChunkIndex = index;
    }

    @Override
    public void nodeSeparator(int index) {
        this.separator = 2;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void addressOperationSeparator(int index) throws CommandFormatException {
        if (this.separator == 1) {
            throw new CommandFormatException("Node type is not complete at index " + index);
        }
        this.separator = 3;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void operationName(int index, String operationName) throws OperationFormatException {
        if (this.validation) {
            super.operationName(index, operationName);
        } else {
            this.validatedOperationName(index, operationName);
        }
    }

    @Override
    public void validatedOperationName(int index, String operationName) throws OperationFormatException {
        this.operationName = operationName;
        this.separator = 0;
        this.lastChunkIndex = index;
    }

    @Override
    public void propertyListStart(int index) {
        this.separator = 4;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void propertyName(int index, String propertyName) throws OperationFormatException {
        if (this.validation) {
            super.propertyName(index, propertyName);
        } else {
            this.validatedPropertyName(index, propertyName);
        }
    }

    @Override
    protected void validatedPropertyName(int index, String propertyName) throws OperationFormatException {
        this.putProperty(propertyName, null);
        this.lastPropName = propertyName;
        this.lastPropValue = null;
        this.separator = 0;
        this.lastChunkIndex = index;
    }

    @Override
    public void propertyNameValueSeparator(int index) {
        this.separator = 5;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void property(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        if (this.validation) {
            super.property(name, value, nameValueSeparatorIndex);
        } else {
            this.validatedProperty(name, value, nameValueSeparatorIndex);
        }
    }

    @Override
    protected void validatedProperty(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        if (name == null) {
            this.addArgument(value);
        } else {
            this.putProperty(name, value);
        }
        this.lastPropName = name;
        this.lastPropValue = value;
        this.separator = 0;
        if (nameValueSeparatorIndex >= 0) {
            this.lastSeparatorIndex = nameValueSeparatorIndex;
        }
        this.lastChunkIndex = nameValueSeparatorIndex;
    }

    @Override
    public void propertySeparator(int index) {
        this.separator = 6;
        this.lastSeparatorIndex = index;
        this.lastPropName = null;
        this.lastPropValue = null;
    }

    @Override
    public void propertyListEnd(int index) {
        this.separator = 7;
        this.lastSeparatorIndex = index;
        this.lastPropName = null;
        this.lastPropValue = null;
    }

    @Override
    public void headerListStart(int index) {
        this.separator = 8;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void headerListEnd(int index) {
        this.separator = 0;
        this.lastSeparatorIndex = index;
        this.operationComplete = true;
    }

    @Override
    public void headerSeparator(int index) {
        this.separator = 9;
        this.lastSeparatorIndex = index;
    }

    @Override
    public void headerNameValueSeparator(int index) {
        this.separator = 5;
        this.lastSeparatorIndex = index;
    }

    @Override
    public ParsingStateCallbackHandler headerName(int index, String headerName) throws CommandFormatException {
        this.separator = 0;
        this.lastChunkIndex = index;
        this.lastHeaderName = headerName;
        this.lastHeader = null;
        if (headerName.equals("rollout")) {
            return new RolloutPlanHeaderCallbackHandler(this);
        }
        return null;
    }

    @Override
    public void header(String name, String value, int valueIndex) throws CommandFormatException {
        if (this.headers == null) {
            this.headers = new LinkedHashMap();
        }
        this.lastHeader = new SimpleParsedOperationRequestHeader(name, value);
        this.headers.put(name, this.lastHeader);
        this.separator = 0;
        this.lastSeparatorIndex = valueIndex - 1;
        this.lastChunkIndex = valueIndex;
        this.lastHeaderName = null;
    }

    public void header(ParsedOperationRequestHeader header) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap();
        }
        this.lastHeader = header;
        this.headers.put(header.getName(), header);
        this.separator = 0;
        this.lastHeaderName = null;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null || this.lastHeaderName != null;
    }

    @Override
    public boolean hasHeader(String name) {
        return this.headers != null && this.headers.containsKey(name);
    }

    @Override
    public String getLastHeaderName() {
        return this.lastHeaderName;
    }

    @Override
    public Collection<ParsedOperationRequestHeader> getHeaders() {
        return this.headers == null ? Collections.emptyList() : this.headers.values();
    }

    @Override
    public ParsedOperationRequestHeader getLastHeader() {
        return this.lastHeader;
    }

    @Override
    public void rootNode(int index) throws OperationFormatException {
        if (this.addressChanged) {
            throw new OperationFormatException("Can't reset to root in the middle of the path @" + index);
        }
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        } else {
            this.address.reset();
        }
        this.separator = 0;
        this.lastChunkIndex = index;
        this.addressChanged = true;
    }

    @Override
    public void parentNode(int index) {
        if (this.address == null) {
            throw new IllegalStateException("The address hasn't been initialized yet.");
        }
        this.address.toParentNode();
        this.separator = 0;
        this.lastChunkIndex = index;
        this.addressChanged = true;
    }

    @Override
    public void nodeType(int index) {
        if (this.address == null) {
            throw new IllegalStateException("The address hasn't been initialized yet.");
        }
        this.address.toNodeType();
        this.separator = 0;
        this.lastChunkIndex = index;
        this.addressChanged = true;
    }

    @Override
    public void nodeName(int index, String nodeName) throws OperationFormatException {
        if (this.validation) {
            super.nodeName(index, nodeName);
        } else {
            this.validatedNodeName(index, nodeName);
        }
        this.addressChanged = true;
    }

    @Override
    public void nodeType(int index, String nodeType) throws OperationFormatException {
        if (this.validation) {
            super.nodeType(index, nodeType);
        } else {
            this.validatedNodeType(index, nodeType);
        }
        this.addressChanged = true;
    }

    @Override
    public void nodeTypeOrName(int index, String typeOrName) throws OperationFormatException {
        if (this.address == null) {
            this.address = new DefaultOperationRequestAddress();
        }
        if (this.address.endsOnType()) {
            this.nodeName(index, typeOrName);
        } else {
            this.nodeType(index, typeOrName);
        }
        this.separator = 0;
        this.addressChanged = true;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.props.keySet();
    }

    @Override
    public String getPropertyValue(String name) {
        return this.props.get(name);
    }

    @Override
    public int getLastSeparatorIndex() {
        return this.lastSeparatorIndex;
    }

    @Override
    public int getLastChunkIndex() {
        return this.lastChunkIndex;
    }

    @Override
    public void outputTarget(int index, String outputTarget) {
        this.outputTarget = outputTarget;
        this.lastChunkIndex = index;
    }

    @Override
    public String getOutputTarget() {
        return this.outputTarget;
    }

    @Override
    public String getLastParsedPropertyName() {
        return this.lastPropName;
    }

    @Override
    public String getLastParsedPropertyValue() {
        return this.lastPropValue;
    }

    public ModelNode toOperationRequest(CommandContext ctx) throws CommandFormatException {
        return Util.toOperationRequest(ctx, this);
    }

    @Override
    public void setFormat(CommandLineFormat format) {
        this.format = format;
    }

    @Override
    public CommandLineFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean endsOnHeaderSeparator() {
        return this.separator == 9;
    }

    private void putProperty(String key, String name) {
        if (this.props.isEmpty()) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, name);
    }

    private void addArgument(String value) {
        if (this.otherArgs.isEmpty()) {
            this.otherArgs = new ArrayList<String>();
        }
        this.otherArgs.add(value);
    }
}

