/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen;

import java.io.Serializable;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.ContextSupport;
import nu.xom.jaxen.FunctionContext;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.JaxenHandler;
import nu.xom.jaxen.NamespaceContext;
import nu.xom.jaxen.Navigator;
import nu.xom.jaxen.SimpleNamespaceContext;
import nu.xom.jaxen.SimpleVariableContext;
import nu.xom.jaxen.VariableContext;
import nu.xom.jaxen.XPath;
import nu.xom.jaxen.XPathFunctionContext;
import nu.xom.jaxen.XPathSyntaxException;
import nu.xom.jaxen.expr.Expr;
import nu.xom.jaxen.expr.XPathExpr;
import nu.xom.jaxen.function.BooleanFunction;
import nu.xom.jaxen.function.NumberFunction;
import nu.xom.jaxen.function.StringFunction;
import nu.xom.jaxen.saxpath.SAXPathException;
import nu.xom.jaxen.saxpath.XPathReader;
import nu.xom.jaxen.saxpath.helpers.XPathReaderFactory;
import nu.xom.jaxen.util.SingletonList;

public class BaseXPath
implements XPath,
Serializable {
    private static final long serialVersionUID = -1993731281300293168L;
    private final String exprText;
    private final XPathExpr xpath;
    private ContextSupport support;
    private Navigator navigator;

    protected BaseXPath(String string) throws JaxenException {
        try {
            XPathReader xPathReader = XPathReaderFactory.createReader();
            JaxenHandler jaxenHandler = new JaxenHandler();
            xPathReader.setXPathHandler(jaxenHandler);
            xPathReader.parse(string);
            this.xpath = jaxenHandler.getXPathExpr();
        }
        catch (nu.xom.jaxen.saxpath.XPathSyntaxException xPathSyntaxException) {
            throw new XPathSyntaxException(xPathSyntaxException);
        }
        catch (SAXPathException sAXPathException) {
            throw new JaxenException(sAXPathException);
        }
        this.exprText = string;
    }

    public BaseXPath(String string, Navigator navigator) throws JaxenException {
        this(string);
        this.navigator = navigator;
    }

    public Object evaluate(Object object) throws JaxenException {
        Object e;
        List list = this.selectNodes(object);
        if (list != null && list.size() == 1 && ((e = list.get(0)) instanceof String || e instanceof Number || e instanceof Boolean)) {
            return e;
        }
        return list;
    }

    public List selectNodes(Object object) throws JaxenException {
        Context context = this.getContext(object);
        return this.selectNodesForContext(context);
    }

    public Object selectSingleNode(Object object) throws JaxenException {
        List list = this.selectNodes(object);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String valueOf(Object object) throws JaxenException {
        return this.stringValueOf(object);
    }

    public String stringValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return "";
        }
        return StringFunction.evaluate(object2, context.getNavigator());
    }

    public boolean booleanValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        List list = this.selectNodesForContext(context);
        if (list == null) {
            return false;
        }
        return BooleanFunction.evaluate(list, context.getNavigator());
    }

    public Number numberValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        return NumberFunction.evaluate(object2, context.getNavigator());
    }

    public void addNamespace(String string, String string2) throws JaxenException {
        NamespaceContext namespaceContext = this.getNamespaceContext();
        if (namespaceContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)namespaceContext).addNamespace(string, string2);
            return;
        }
        throw new JaxenException("Operation not permitted while using a non-simple namespace context.");
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    public NamespaceContext getNamespaceContext() {
        return this.getContextSupport().getNamespaceContext();
    }

    public FunctionContext getFunctionContext() {
        return this.getContextSupport().getFunctionContext();
    }

    public VariableContext getVariableContext() {
        return this.getContextSupport().getVariableContext();
    }

    public Expr getRootExpr() {
        return this.xpath.getRootExpr();
    }

    public String toString() {
        return this.exprText;
    }

    public String debug() {
        return this.xpath.toString();
    }

    protected Context getContext(Object object) {
        if (object instanceof Context) {
            return (Context)object;
        }
        Context context = new Context(this.getContextSupport());
        if (object instanceof List) {
            context.setNodeSet((List)object);
        } else {
            SingletonList singletonList = new SingletonList(object);
            context.setNodeSet(singletonList);
        }
        return context;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    public Navigator getNavigator() {
        return this.navigator;
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    protected List selectNodesForContext(Context context) throws JaxenException {
        List list = this.xpath.asList(context);
        return list;
    }

    protected Object selectSingleNodeForContext(Context context) throws JaxenException {
        List list = this.selectNodesForContext(context);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

