/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.entities.EntityConfiguration;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.property.Setter;

public abstract class AbstractToOneMapper
implements PropertyMapper {
    private final PropertyData propertyData;

    protected AbstractToOneMapper(PropertyData propertyData) {
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        if (obj != null) {
            this.nullSafeMapToEntityFromMap(verCfg, obj, data, primaryKey, versionsReader, revision);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }

    protected EntityInfo getEntityInfo(AuditConfiguration verCfg, String entityName) {
        EntityConfiguration entCfg = verCfg.getEntCfg().get(entityName);
        boolean isRelationAudited = true;
        if (entCfg == null) {
            entCfg = verCfg.getEntCfg().getNotVersionEntityConfiguration(entityName);
            isRelationAudited = false;
        }
        Class entityClass = ReflectionTools.loadClass(entCfg.getEntityClassName(), verCfg.getClassLoaderService());
        return new EntityInfo(entityClass, entityName, isRelationAudited);
    }

    protected void setPropertyValue(Object targetObject, Object value) {
        Setter setter = ReflectionTools.getSetter(targetObject.getClass(), this.propertyData);
        setter.set(targetObject, value, null);
    }

    protected PropertyData getPropertyData() {
        return this.propertyData;
    }

    public abstract void nullSafeMapToEntityFromMap(AuditConfiguration var1, Object var2, Map var3, Object var4, AuditReaderImplementor var5, Number var6);

    protected class EntityInfo {
        private final Class entityClass;
        private final String entityName;
        private final boolean audited;

        public EntityInfo(Class entityClass, String entityName, boolean audited) {
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.audited = audited;
        }

        public Class getEntityClass() {
            return this.entityClass;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public boolean isAudited() {
            return this.audited;
        }
    }
}

