/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.JPATreePrinter;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.EmptyResultQuery;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchIndexedFieldProvider;
import org.infinispan.query.dsl.embedded.impl.HybridQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.remote.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.query.remote.SecurityActions;
import org.infinispan.query.remote.client.QueryRequest;
import org.infinispan.query.remote.client.QueryResponse;
import org.infinispan.query.remote.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.indexing.IndexingMetadata;
import org.infinispan.query.remote.indexing.ProtobufIndexedFieldProvider;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.logging.Log;
import org.infinispan.server.core.QueryFacade;
import org.infinispan.util.KeyValuePair;

public final class QueryFacadeImpl
implements QueryFacade {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    public static final String TYPE_FIELD_NAME = "$type$";
    public static final String NULL_TOKEN = "_null_";
    private final QueryParser queryParser = new QueryParser();
    private final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();

    public byte[] query(AdvancedCache<byte[], byte[]> cache, byte[] query) {
        try {
            SerializationContext serCtx = ProtobufMetadataManager.getSerializationContextInternal(cache.getCacheManager());
            QueryRequest request = (QueryRequest)ProtobufUtil.fromByteArray((SerializationContext)serCtx, (byte[])query, (int)0, (int)query.length, QueryRequest.class);
            Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache);
            boolean isIndexed = cacheConfiguration.indexing().index().isEnabled();
            boolean isCompatMode = cacheConfiguration.compatibility().enabled();
            org.infinispan.query.dsl.Query q = this.buildQuery(cache, serCtx, request, isIndexed, isCompatMode);
            QueryResponse response = this.makeResponse(isCompatMode, serCtx, q);
            return ProtobufUtil.toByteArray((SerializationContext)serCtx, (Object)response);
        }
        catch (IOException e) {
            throw log.errorExecutingQuery(e);
        }
    }

    private org.infinispan.query.dsl.Query buildQuery(AdvancedCache<?, ?> cache, SerializationContext serCtx, QueryRequest request, boolean isIndexed, boolean isCompatMode) {
        if (isIndexed) {
            SearchManager searchManager = Search.getSearchManager(cache);
            SearchIntegrator searchFactory = (SearchIntegrator)searchManager.unwrap(SearchIntegrator.class);
            Class matcherImplClass = isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class;
            BaseMatcher matcher = (BaseMatcher)SecurityActions.getCacheComponentRegistry(cache).getComponent(matcherImplClass);
            FilterParsingResult parsingResult = matcher.parse(request.getJpqlString(), null);
            BooleanExpr normalizedExpr = this.booleanFilterNormalizer.normalize(parsingResult.getQuery());
            if (normalizedExpr == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(null, cache, request.getJpqlString(), request.getStartOffset(), request.getMaxResults());
            }
            Object indexedFieldProvider = isCompatMode ? new HibernateSearchIndexedFieldProvider(searchFactory, (Class)parsingResult.getTargetEntityMetadata()) : new ProtobufIndexedFieldProvider((Descriptor)parsingResult.getTargetEntityMetadata());
            BooleShannonExpansion bse = new BooleShannonExpansion((BooleShannonExpansion.IndexedFieldProvider)indexedFieldProvider);
            BooleanExpr expansion = bse.expand(normalizedExpr);
            if (expansion == normalizedExpr) {
                return this.buildLuceneQuery(cache, isCompatMode, serCtx, request.getJpqlString(), request.getStartOffset(), request.getMaxResults());
            }
            if (expansion == ConstantBooleanExpr.TRUE) {
                return new EmbeddedQuery(null, cache, this.makeFilter(cache, true, isCompatMode, request.getJpqlString()), request.getStartOffset(), request.getMaxResults());
            }
            String expandedJpaOut = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (BooleanExpr)expansion, null);
            org.infinispan.query.dsl.Query expandedQuery = this.buildLuceneQuery(cache, isCompatMode, serCtx, expandedJpaOut, -1L, -1);
            ProtobufMatcher protobufMatcher = (ProtobufMatcher)SecurityActions.getCacheComponentRegistry(cache).getComponent(ProtobufMatcher.class);
            ObjectFilter objectFilter = protobufMatcher.getObjectFilter(request.getJpqlString());
            return new HybridQuery(null, cache, request.getJpqlString(), objectFilter, request.getStartOffset(), request.getMaxResults(), expandedQuery);
        }
        return new EmbeddedQuery(null, cache, this.makeFilter(cache, false, isCompatMode, request.getJpqlString()), request.getStartOffset(), request.getMaxResults());
    }

    private JPAFilterAndConverter makeFilter(final AdvancedCache<?, ?> cache, final boolean isIndexed, final boolean isCompatMode, final String jpaQuery) {
        return SecurityActions.doPrivileged(new PrivilegedAction<JPAFilterAndConverter>(){

            @Override
            public JPAFilterAndConverter run() {
                JPAProtobufFilterAndConverter filter = isIndexed && !isCompatMode ? new JPAProtobufFilterAndConverter(jpaQuery) : new JPAFilterAndConverter(jpaQuery, isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
                filter.injectDependencies((Cache)cache);
                filter.getObjectFilter();
                return filter;
            }
        });
    }

    private org.infinispan.query.dsl.Query buildLuceneQuery(AdvancedCache<?, ?> cache, boolean isCompatMode, SerializationContext serCtx, String jpqlString, long startOffset, int maxResults) {
        LuceneQueryParsingResult parsingResult;
        SearchManager searchManager = Search.getSearchManager(cache);
        SearchIntegrator searchFactory = (SearchIntegrator)searchManager.unwrap(SearchIntegrator.class);
        QueryCache queryCache = ComponentRegistryUtils.getQueryCache(cache);
        if (queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)queryCache.get(queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.transformJpaToLucene(isCompatMode, serCtx, jpqlString, searchFactory);
                queryCache.put(queryCacheKey, (Object)parsingResult);
            }
        } else {
            parsingResult = this.transformJpaToLucene(isCompatMode, serCtx, jpqlString, searchFactory);
        }
        Query luceneQuery = parsingResult.getQuery();
        if (!isCompatMode) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term(TYPE_FIELD_NAME, parsingResult.getTargetEntityName())), BooleanClause.Occur.MUST));
            booleanQuery.add(new BooleanClause(luceneQuery, BooleanClause.Occur.MUST));
            luceneQuery = booleanQuery;
        }
        CacheQuery cacheQuery = searchManager.getQuery(luceneQuery, new Class[]{parsingResult.getTargetEntity()});
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        String[] projection = null;
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            int projSize = parsingResult.getProjections().size();
            projection = parsingResult.getProjections().toArray(new String[projSize]);
            cacheQuery = cacheQuery.projection(projection);
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults > 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return new EmbeddedLuceneQuery(null, jpqlString, projection, cacheQuery);
    }

    private LuceneQueryParsingResult transformJpaToLucene(boolean isCompatMode, final SerializationContext serCtx, String jpqlString, SearchIntegrator searchFactory) {
        LuceneProcessingChain processingChain;
        if (isCompatMode) {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? serCtx.getMarshaller(entityName).getJavaClass() : null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities();
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    FieldDescriptor fd = QueryFacadeImpl.this.getFieldDescriptor(serCtx, type, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return NumericFieldBridge.DOUBLE_FIELD_BRIDGE;
                        }
                        case FLOAT: {
                            return NumericFieldBridge.FLOAT_FIELD_BRIDGE;
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return NumericFieldBridge.LONG_FIELD_BRIDGE;
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return NumericFieldBridge.INT_FIELD_BRIDGE;
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), QueryFacadeImpl.NULL_TOKEN);
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(searchFactory, entityNamesResolver).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
        }
        return (LuceneQueryParsingResult)this.queryParser.parseQuery(jpqlString, (AstProcessingChain)processingChain);
    }

    private FieldDescriptor getFieldDescriptor(SerializationContext serCtx, String type, String attributePath) {
        Descriptor messageDescriptor = serCtx.getMessageDescriptor(type);
        FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) {
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }

    private QueryResponse makeResponse(boolean isCompatMode, SerializationContext serCtx, org.infinispan.query.dsl.Query q) throws IOException {
        if (!(q instanceof EmbeddedQuery)) {
            isCompatMode = false;
        }
        List list = q.list();
        int numResults = list.size();
        String[] projection = ((BaseQuery)q).getProjection();
        int projSize = projection != null ? projection.length : 0;
        ArrayList<WrappedMessage> results = new ArrayList<WrappedMessage>(projSize == 0 ? numResults : numResults * projSize);
        for (Object o : list) {
            if (projSize == 0) {
                if (isCompatMode) {
                    o = ProtobufUtil.toWrappedByteArray((SerializationContext)serCtx, o);
                }
                results.add(new WrappedMessage(o));
                continue;
            }
            Object[] row = (Object[])o;
            for (int j = 0; j < projSize; ++j) {
                results.add(new WrappedMessage(row[j]));
            }
        }
        QueryResponse response = new QueryResponse();
        response.setTotalResults((long)q.getResultSize());
        response.setNumResults(numResults);
        response.setProjectionSize(projSize);
        response.setResults(results);
        return response;
    }
}

