/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;

public class PooledConnectionFactoryRemove
extends AbstractRemoveStepHandler {
    public static final PooledConnectionFactoryRemove INSTANCE = new PooledConnectionFactoryRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ModelNode operationAddress = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)operationAddress);
        String name = address.getLastElement().getValue();
        ServiceName hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address")));
        context.removeService(JMSServices.getPooledConnectionFactoryBaseServiceName(hqServiceName).append(new String[]{name}));
        this.removeJNDIAliases(context, model.require(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList());
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }

    private void removeJNDIAliases(OperationContext context, List<ModelNode> entries) {
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                ContextNames.BindInfo aliasBindInfo = ContextNames.bindInfoFor((String)entries.get(i).asString());
                context.removeService(aliasBindInfo.getBinderServiceName());
            }
        }
    }
}

