/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.lookup;

import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static final Log log = LogFactory.getLog(GenericTransactionManagerLookup.class);
    public static final GenericTransactionManagerLookup INSTANCE = new GenericTransactionManagerLookup();
    private boolean lookupDone = false;
    private boolean lookupFailed = false;
    private boolean noJBossTM = false;
    private TransactionManager tm = null;
    private static String[][] knownJNDIManagers = new String[][]{{"java:jboss/TransactionManager", "JBoss AS 7"}, {"java:/TransactionManager", "JBoss AS 4 ~ 6, JRun4"}, {"java:comp/TransactionManager", "Resin 3.x"}, {"java:appserver/TransactionManager", "Sun Glassfish"}, {"java:pm/TransactionManager", "Borland, Sun"}, {"javax.transaction.TransactionManager", "BEA WebLogic"}, {"java:comp/UserTransaction", "Resin, Orion, JOnAS (JOTM)"}, {"osgi:service/javax.transaction.TransactionManager", "Karaf"}};
    private static final String WS_FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
    private static final String WS_FACTORY_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
    private GlobalConfiguration globalCfg;

    @Inject
    public void init(GlobalConfiguration globalCfg) {
        this.globalCfg = globalCfg;
    }

    @Override
    public synchronized TransactionManager getTransactionManager() {
        if (!this.lookupDone) {
            this.doLookups(this.globalCfg.classLoader());
        }
        if (this.tm != null) {
            return this.tm;
        }
        if (this.lookupFailed) {
            if (!this.noJBossTM) {
                this.tryEmbeddedJBossTM();
            }
            if (this.noJBossTM) {
                this.useDummyTM();
            }
        }
        return this.tm;
    }

    private void useDummyTM() {
        this.tm = DummyTransactionManager.getInstance();
        log.fallingBackToDummyTm();
    }

    private void tryEmbeddedJBossTM() {
        try {
            JBossStandaloneJTAManagerLookup jBossStandaloneJTAManagerLookup = new JBossStandaloneJTAManagerLookup();
            jBossStandaloneJTAManagerLookup.init(this.globalCfg);
            this.tm = jBossStandaloneJTAManagerLookup.getTransactionManager();
        }
        catch (Exception e) {
            this.noJBossTM = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLookups(ClassLoader cl) {
        Class clazz;
        if (this.lookupFailed) {
            return;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            log.failedToCreateInitialCtx(e);
            this.lookupFailed = true;
            Util.close((Context)ctx);
            return;
        }
        try {
            for (String[] knownJNDIManager : knownJNDIManagers) {
                Object jndiObject;
                try {
                    log.debugf("Trying to lookup TransactionManager for %s", knownJNDIManager[1]);
                    jndiObject = ctx.lookup(knownJNDIManager[0]);
                }
                catch (NamingException e) {
                    log.debugf("Failed to perform a lookup for [%s (%s)]", knownJNDIManager[0], knownJNDIManager[1]);
                    continue;
                }
                if (!(jndiObject instanceof TransactionManager)) continue;
                this.tm = (TransactionManager)jndiObject;
                log.debugf("Found TransactionManager for %s", knownJNDIManager[1]);
                return;
            }
        }
        finally {
            Util.close((Context)ctx);
        }
        try {
            log.debugf("Trying WebSphere 5.1: %s", WS_FACTORY_CLASS_5_1);
            clazz = Util.loadClassStrict((String)WS_FACTORY_CLASS_5_1, (ClassLoader)cl);
            log.debugf("Found WebSphere 5.1: %s", WS_FACTORY_CLASS_5_1);
        }
        catch (ClassNotFoundException ex) {
            try {
                log.debugf("Trying WebSphere 5.0: %s", WS_FACTORY_CLASS_5_0);
                clazz = Util.loadClassStrict((String)WS_FACTORY_CLASS_5_0, (ClassLoader)cl);
                log.debugf("Found WebSphere 5.0: %s", WS_FACTORY_CLASS_5_0);
            }
            catch (ClassNotFoundException ex2) {
                try {
                    log.debugf("Trying WebSphere 4: %s", WS_FACTORY_CLASS_4);
                    clazz = Util.loadClassStrict((String)WS_FACTORY_CLASS_4, (ClassLoader)cl);
                    log.debugf("Found WebSphere 4: %s", WS_FACTORY_CLASS_4);
                }
                catch (ClassNotFoundException ex3) {
                    log.debug("Couldn't find any WebSphere TransactionManager factory class, neither for WebSphere version 5.1 nor 5.0 nor 4");
                    this.lookupFailed = true;
                    return;
                }
            }
        }
        try {
            Class<?>[] signature = null;
            Object[] args = null;
            Method method = clazz.getMethod("getTransactionManager", signature);
            this.tm = (TransactionManager)method.invoke(null, args);
        }
        catch (Exception ex) {
            log.unableToInvokeWebsphereStaticGetTmMethod(ex, clazz.getName());
        }
        this.lookupDone = true;
    }
}

