/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.server.handlers.cache.LimitedBufferSlicePool;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.StreamSinkConduit;

public class ResponseCachingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final DirectBufferCache.CacheEntry cacheEntry;
    private final long length;
    private long written;

    public ResponseCachingStreamSinkConduit(StreamSinkConduit next, DirectBufferCache.CacheEntry cacheEntry, long length) {
        super(next);
        this.cacheEntry = cacheEntry;
        this.length = length;
        for (LimitedBufferSlicePool.PooledByteBuffer buffer : cacheEntry.buffers()) {
            buffer.getResource().clear();
        }
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer((ReadableByteChannel)source, (long)count, (ByteBuffer)throughBuffer, (WritableByteChannel)new ConduitWritableByteChannel((StreamSinkConduit)this));
    }

    public int write(ByteBuffer src) throws IOException {
        ByteBuffer origSrc = src.duplicate();
        int totalWritten = super.write(src);
        if (totalWritten > 0) {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
            ByteBuffer[] buffers = new ByteBuffer[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = pooled[i].getResource();
            }
            origSrc.limit(origSrc.position() + totalWritten);
            this.written += (long)Buffers.copy((ByteBuffer[])buffers, (int)0, (int)buffers.length, (ByteBuffer)origSrc);
            if (this.written == this.length) {
                for (ByteBuffer buffer : buffers) {
                    buffer.flip();
                }
                this.cacheEntry.enable();
            }
        }
        return totalWritten;
    }

    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        ByteBuffer[] origSrc = new ByteBuffer[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            origSrc[i] = srcs[i].duplicate();
        }
        long totalWritten = super.write(srcs, offs, len);
        if (totalWritten > 0L) {
            LimitedBufferSlicePool.PooledByteBuffer[] pooled = this.cacheEntry.buffers();
            ByteBuffer[] buffers = new ByteBuffer[pooled.length];
            for (int i = 0; i < buffers.length; ++i) {
                buffers[i] = pooled[i].getResource();
            }
            long leftToCopy = totalWritten;
            for (int i = 0; i < len; ++i) {
                ByteBuffer buf = origSrc[offs + i];
                if ((long)buf.remaining() > leftToCopy) {
                    buf.limit((int)((long)buf.position() + leftToCopy));
                }
                Buffers.copy((ByteBuffer[])buffers, (int)0, (int)buffers.length, (ByteBuffer)buf);
                if ((leftToCopy -= (long)buf.remaining()) == 0L) break;
            }
            this.written += totalWritten;
            if (this.written == this.length) {
                for (ByteBuffer buffer : buffers) {
                    buffer.flip();
                }
                this.cacheEntry.enable();
            }
        }
        return totalWritten;
    }

    public void terminateWrites() throws IOException {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        super.terminateWrites();
    }

    public void truncateWrites() throws IOException {
        if (this.written != this.length) {
            this.cacheEntry.disable();
            this.cacheEntry.dereference();
        }
        super.truncateWrites();
    }
}

