/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server;

import org.hornetq.core.server.HornetQComponent;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.utils.SizeFormatterUtil;

public class MemoryManager
implements HornetQComponent {
    private final Runtime runtime = Runtime.getRuntime();
    private final long measureInterval;
    private final int memoryWarningThreshold;
    private volatile boolean started;
    private Thread thread;
    private volatile boolean low;

    public MemoryManager(int memoryWarningThreshold, long measureInterval) {
        this.measureInterval = measureInterval;
        this.memoryWarningThreshold = memoryWarningThreshold;
    }

    public boolean isMemoryLow() {
        return this.low;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        HornetQServerLogger.LOGGER.debug("Starting MemoryManager with MEASURE_INTERVAL: " + this.measureInterval + " FREE_MEMORY_PERCENT: " + this.memoryWarningThreshold);
        if (this.started) {
            return;
        }
        this.started = true;
        this.thread = new Thread((Runnable)new MemoryRunnable(), "hornetq-memory-manager-thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class MemoryRunnable
    implements Runnable {
        private MemoryRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                block5: {
                    try {
                        if (MemoryManager.this.thread.isInterrupted() && !MemoryManager.this.started) break;
                        Thread.sleep(MemoryManager.this.measureInterval);
                    }
                    catch (InterruptedException ignore) {
                        if (MemoryManager.this.started) break block5;
                        return;
                    }
                }
                long maxMemory = MemoryManager.this.runtime.maxMemory();
                long totalMemory = MemoryManager.this.runtime.totalMemory();
                long freeMemory = MemoryManager.this.runtime.freeMemory();
                long availableMemory = freeMemory + maxMemory - totalMemory;
                double availableMemoryPercent = 100.0 * (double)availableMemory / (double)maxMemory;
                StringBuilder info = new StringBuilder();
                info.append(String.format("free memory:      %s%n", SizeFormatterUtil.sizeof((long)freeMemory)));
                info.append(String.format("max memory:       %s%n", SizeFormatterUtil.sizeof((long)maxMemory)));
                info.append(String.format("total memory:     %s%n", SizeFormatterUtil.sizeof((long)totalMemory)));
                info.append(String.format("available memory: %.2f%%%n", availableMemoryPercent));
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug(info);
                }
                if (availableMemoryPercent <= (double)MemoryManager.this.memoryWarningThreshold) {
                    HornetQServerLogger.LOGGER.memoryError(MemoryManager.this.memoryWarningThreshold, info.toString());
                    MemoryManager.this.low = true;
                    continue;
                }
                MemoryManager.this.low = false;
            }
        }
    }
}

