/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import java.util.Arrays;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.sso.SSOManagerFactoryBuilderProvider;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManagerFactory;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryBuilder;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManagerFactory;

public class DistributableSingleSignOnManagerFactoryBuilder
implements org.wildfly.extension.undertow.security.sso.DistributableSingleSignOnManagerFactoryBuilder,
Value<SingleSignOnManagerFactory> {
    private final SSOManagerFactoryBuilderProvider<Batch> provider;
    private final InjectedValue<SSOManagerFactory> manager = new InjectedValue();
    private final InjectedValue<SessionManagerRegistry> registry = new InjectedValue();

    private static SSOManagerFactoryBuilderProvider<Batch> load() {
        Iterator<SSOManagerFactoryBuilderProvider> i$ = ServiceLoader.load(SSOManagerFactoryBuilderProvider.class, SSOManagerFactoryBuilderProvider.class.getClassLoader()).iterator();
        if (i$.hasNext()) {
            SSOManagerFactoryBuilderProvider builder = i$.next();
            return builder;
        }
        return null;
    }

    public DistributableSingleSignOnManagerFactoryBuilder() {
        this(DistributableSingleSignOnManagerFactoryBuilder.load());
    }

    private DistributableSingleSignOnManagerFactoryBuilder(SSOManagerFactoryBuilderProvider<Batch> builder) {
        this.provider = builder;
    }

    public ServiceBuilder<SingleSignOnManagerFactory> build(ServiceTarget target, ServiceName name, String serverName, String hostName) {
        Builder factoryBuilder = this.provider.getBuilder(hostName);
        SessionManagerRegistryBuilder registryBuilder = new SessionManagerRegistryBuilder(serverName, hostName);
        for (Builder builder : Arrays.asList(factoryBuilder, registryBuilder)) {
            builder.build(target).install();
        }
        return target.addService(name, (Service)new ValueService((Value)this)).addDependency(factoryBuilder.getServiceName(), SSOManagerFactory.class, this.manager).addDependency(registryBuilder.getServiceName(), SessionManagerRegistry.class, this.registry).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public SingleSignOnManagerFactory getValue() {
        return new DistributableSingleSignOnManagerFactory((SSOManagerFactory<AuthenticatedSessionManager.AuthenticatedSession, String, Batch>)((SSOManagerFactory)this.manager.getValue()), (SessionManagerRegistry)this.registry.getValue());
    }
}

