/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.config.AnnotationConfig;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;

public final class EnumDescriptor
extends AnnotatedDescriptorImpl
implements GenericDescriptor {
    private Integer typeId;
    private final List<Option> options;
    private final List<EnumValueDescriptor> values;
    private final Map<Integer, EnumValueDescriptor> valueByNumber = new HashMap<Integer, EnumValueDescriptor>();
    private final Map<String, EnumValueDescriptor> valueByName = new HashMap<String, EnumValueDescriptor>();
    private FileDescriptor fileDescriptor;
    private Descriptor containingType;

    private EnumDescriptor(Builder builder) {
        super(builder.name, builder.fullName, builder.documentation);
        this.options = Collections.unmodifiableList(builder.options);
        this.values = Collections.unmodifiableList(builder.values);
        for (EnumValueDescriptor value : this.values) {
            value.setContainingEnum(this);
            this.valueByNumber.put(value.getNumber(), value);
            this.valueByName.put(value.getName(), value);
        }
    }

    protected AnnotationConfig<EnumDescriptor> getAnnotationConfig(String annotationName) {
        return this.fileDescriptor.configuration.enumAnnotations().get(annotationName);
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }

    @Override
    public Integer getTypeId() {
        return this.typeId;
    }

    @Override
    public Descriptor getContainingType() {
        return this.containingType;
    }

    void setContainingType(Descriptor containingType) {
        this.containingType = containingType;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public List<EnumValueDescriptor> getValues() {
        return this.values;
    }

    public EnumValueDescriptor findValueByNumber(int number) {
        return this.valueByNumber.get(number);
    }

    public EnumValueDescriptor findValueByName(String name) {
        return this.valueByName.get(name);
    }

    void setFileDescriptor(FileDescriptor fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
        for (EnumValueDescriptor valueDescriptor : this.values) {
            valueDescriptor.setFileDescriptor(fileDescriptor);
        }
        this.typeId = (Integer)this.getProcessedAnnotation("TypeId");
    }

    public static class Builder {
        private String name;
        private String fullName;
        private List<Option> options;
        private List<EnumValueDescriptor> values;
        private String documentation;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFullName(String fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder withOptions(List<Option> options) {
            this.options = options;
            return this;
        }

        public Builder withValues(List<EnumValueDescriptor> values) {
            this.values = values;
            return this;
        }

        public Builder withDocumentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public EnumDescriptor build() {
            return new EnumDescriptor(this);
        }
    }
}

