/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class Notifier<T> {
    private static final int NOTIFIED = 0;
    private static final int WAITING = 1;
    private final Invoker<T> invoker;
    private final Queue<T> listeners;
    private final Sync sync;

    public Notifier(Invoker<T> invoker) {
        Objects.requireNonNull(invoker, "Invoker must be non-null");
        this.invoker = invoker;
        this.listeners = new ConcurrentLinkedQueue<T>();
        this.sync = new Sync();
    }

    public void add(T listener) {
        Objects.requireNonNull(listener, "Listener must be non-null");
        this.listeners.add(listener);
        if (this.sync.isNotified()) {
            this.trigger();
        }
    }

    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        Objects.requireNonNull(unit, "Time unit must be non-null");
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(time));
    }

    public void fireListener() {
        if (!this.sync.isNotified() && this.sync.releaseShared(1)) {
            this.trigger();
        }
    }

    private void trigger() {
        T listener;
        while ((listener = this.listeners.poll()) != null) {
            this.invoker.invoke(listener);
        }
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        public Sync() {
            this.setState(1);
        }

        public boolean isNotified() {
            return this.getState() == 0;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            return this.compareAndSetState(1, 0);
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            return this.getState() == 0 ? 1 : -1;
        }
    }

    public static interface Invoker<T1> {
        public void invoke(T1 var1);
    }
}

