/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.query.backend.ReadIntensiveClusterRegistryWrapper;
import org.infinispan.query.backend.TransactionHelper;

final class SearchFactoryHandler {
    private final SearchIntegrator searchFactory;
    private final ReadIntensiveClusterRegistryWrapper<String, Class<?>, Boolean> clusterRegistry;
    private final TransactionHelper transactionHelper;
    private final ReentrantLock mutating = new ReentrantLock();

    SearchFactoryHandler(SearchIntegrator searchFactory, ReadIntensiveClusterRegistryWrapper<String, Class<?>, Boolean> clusterRegistry, TransactionHelper transactionHelper) {
        this.searchFactory = searchFactory;
        this.clusterRegistry = clusterRegistry;
        this.transactionHelper = transactionHelper;
    }

    boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            Boolean existingBoolean = this.clusterRegistry.get(potentialNewType);
            if (existingBoolean != null) {
                return existingBoolean;
            }
            this.handleOnDemandRegistration(potentialNewType);
            Boolean isIndexable = this.clusterRegistry.get(potentialNewType);
            return isIndexable != null ? isIndexable : false;
        }
        return false;
    }

    private void handleOnDemandRegistration(Class<?> ... classes) {
        ArrayList reducedSet = new ArrayList(classes.length);
        for (Class<?> type : classes) {
            if (this.clusterRegistry.containsKey(type)) continue;
            reducedSet.add(type);
        }
        if (!reducedSet.isEmpty()) {
            Class[] toAdd = reducedSet.toArray(new Class[reducedSet.size()]);
            this.updateSearchFactory(toAdd);
            this.updateClusterRegistry(toAdd);
        }
    }

    private void updateClusterRegistry(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.clusterRegistry.put(c, this.isIndexed(c));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSearchFactory(Class<?> ... classes) {
        this.mutating.lock();
        try {
            ArrayList reducedSet = new ArrayList(classes.length);
            for (Class<?> type : classes) {
                if (this.isIndexed(type)) continue;
                reducedSet.add(type);
            }
            if (reducedSet.isEmpty()) {
                return;
            }
            final Class[] newtypes = reducedSet.toArray(new Class[reducedSet.size()]);
            this.transactionHelper.runSuspendingTx(new TransactionHelper.Operation(){

                @Override
                public void execute() {
                    boolean isStatisticsEnabled = SearchFactoryHandler.this.searchFactory.getStatistics().isStatisticsEnabled();
                    SearchFactoryHandler.this.searchFactory.addClasses(newtypes);
                    SearchFactoryHandler.this.searchFactory.getStatistics().setStatisticsEnabled(isStatisticsEnabled);
                }
            });
        }
        finally {
            this.mutating.unlock();
        }
    }

    boolean isIndexed(Class<?> c) {
        return this.searchFactory.getIndexBinding(c) != null;
    }

    void handleClusterRegistryRegistration(Class<?> clazz) {
        if (this.isIndexed(clazz)) {
            return;
        }
        this.updateSearchFactory(clazz);
    }

    void enableClasses(Class[] classes) {
        this.handleOnDemandRegistration(classes);
    }
}

