/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.Index;

public class IndexingConfiguration
extends AbstractTypedPropertiesConfiguration {
    public static final AttributeDefinition<Index> INDEX = AttributeDefinition.builder((String)"index", (Object)((Object)Index.NONE)).immutable().build();
    public static final AttributeDefinition<Boolean> AUTO_CONFIG = AttributeDefinition.builder((String)"autoConfig", (Object)false).immutable().build();
    private static final String DIRECTORY_PROVIDER_KEY = "directory_provider";
    private static final String RAM_DIRECTORY_PROVIDER = "ram";
    private final Attribute<Index> index;
    private final Attribute<Boolean> autoConfig;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexingConfiguration.class, AbstractTypedPropertiesConfiguration.attributeSet(), new AttributeDefinition[]{INDEX, AUTO_CONFIG});
    }

    public IndexingConfiguration(AttributeSet attributes) {
        super(attributes);
        this.index = attributes.attribute(INDEX);
        this.autoConfig = attributes.attribute(AUTO_CONFIG);
    }

    @Deprecated
    public boolean enabled() {
        return this.index().isEnabled();
    }

    @Deprecated
    public boolean indexLocalOnly() {
        return this.index().isLocalOnly();
    }

    public TypedProperties properties() {
        return super.properties();
    }

    public Index index() {
        return (Index)((Object)this.index.get());
    }

    public boolean autoConfig() {
        return (Boolean)this.autoConfig.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean indexShareable() {
        TypedProperties properties = this.properties();
        boolean hasRamDirectoryProvider = false;
        for (Object objKey : properties.keySet()) {
            String key = (String)objKey;
            if (!key.endsWith(DIRECTORY_PROVIDER_KEY)) continue;
            if (properties.get((Object)key).equals(RAM_DIRECTORY_PROVIDER)) {
                hasRamDirectoryProvider = true;
                continue;
            }
            return true;
        }
        return !hasRamDirectoryProvider;
    }

    public String toString() {
        return "IndexingConfiguration [attributes=" + this.attributes + "]";
    }
}

