/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.RemoteFetchingCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.util.ReadOnlySegmentAwareMap;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class NonTxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(NonTxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitRemoteFetchingCommand(ctx, command, false);
    }

    @Override
    public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.visitRemoteFetchingCommand(ctx, command, true);
    }

    private <T extends AbstractDataCommand> Object visitRemoteFetchingCommand(InvocationContext ctx, T command, boolean returnEntry) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        if (returnValue == null) {
            Object key = command.getKey();
            if (this.needsRemoteGet(ctx, command)) {
                InternalCacheEntry remoteEntry = this.remoteGetCacheEntry(ctx, key, command);
                returnValue = this.computeGetReturn(remoteEntry, returnEntry);
            }
            if (returnValue == null) {
                InternalCacheEntry localEntry = this.fetchValueLocallyIfAvailable(this.dm.getReadConsistentHash(), key);
                if (localEntry != null) {
                    this.wrapInternalCacheEntry(localEntry, ctx, key, false, command);
                }
                returnValue = this.computeGetReturn(localEntry, returnEntry);
            }
        }
        return returnValue;
    }

    private Object computeGetReturn(InternalCacheEntry entry, boolean returnEntry) {
        if (!returnEntry && entry != null) {
            return entry.getValue();
        }
        return entry;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Map<Object, Object> originalMap = command.getMap();
        ConsistentHash ch = this.dm.getConsistentHash();
        Address localAddress = this.rpcManager.getAddress();
        if (ctx.isOriginLocal()) {
            ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(this.rpcManager.getMembers().size() - 1);
            RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
            for (Address member : this.rpcManager.getMembers()) {
                ReadOnlySegmentAwareMap<Object, Object> segmentEntriesMap;
                Set<Integer> segments;
                if (member.equals(this.rpcManager.getAddress()) || (segments = ch.getPrimarySegmentsForOwner(member)).isEmpty() || (segmentEntriesMap = new ReadOnlySegmentAwareMap<Object, Object>(originalMap, ch, segments)).isEmpty()) continue;
                PutMapCommand putMapCommand = new PutMapCommand(command);
                putMapCommand.setMap(segmentEntriesMap);
                CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(member), putMapCommand, options);
                futures.add(future);
            }
            if (futures.size() > 0) {
                CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                CompletableFuture<Void> compFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                try {
                    compFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    throw new RemoteException("Exception while processing put on primary owner", e.getCause());
                }
                catch (TimeoutException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        }
        if (!command.isForwarded() && ch.getNumOwners() > 1) {
            HashMap<Address, HashSet<Integer>> backupOwnerSegments = new HashMap<Address, HashSet<Integer>>();
            int segmentCount = ch.getNumSegments();
            for (int i = 0; i < segmentCount; ++i) {
                Iterator<Address> iter = ch.locateOwnersForSegment(i).iterator();
                if (!iter.next().equals(localAddress)) continue;
                while (iter.hasNext()) {
                    Address backupOwner = iter.next();
                    HashSet<Integer> segments = (HashSet<Integer>)backupOwnerSegments.get(backupOwner);
                    if (segments == null) {
                        segments = new HashSet<Integer>();
                        backupOwnerSegments.put(backupOwner, segments);
                    }
                    segments.add(i);
                }
            }
            int backupOwnerSize = backupOwnerSegments.size();
            if (backupOwnerSize > 0) {
                ArrayList<CompletableFuture<Map<Address, Response>>> futures = new ArrayList<CompletableFuture<Map<Address, Response>>>(backupOwnerSize);
                RpcOptions options = this.rpcManager.getDefaultRpcOptions(this.isSynchronous(command));
                command.setFlags(Flag.SKIP_LOCKING);
                command.setForwarded(true);
                for (Map.Entry entry : backupOwnerSegments.entrySet()) {
                    Set segments = (Set)entry.getValue();
                    ReadOnlySegmentAwareMap<Object, Object> segmentEntriesMap = new ReadOnlySegmentAwareMap<Object, Object>(originalMap, ch, segments);
                    if (segmentEntriesMap.isEmpty()) continue;
                    PutMapCommand copy = new PutMapCommand(command);
                    copy.setMap(segmentEntriesMap);
                    CompletableFuture<Map<Address, Response>> future = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(entry.getKey()), copy, options);
                    futures.add(future);
                }
                command.setForwarded(false);
                if (futures.size() > 0) {
                    CompletableFuture[] futuresArray = new CompletableFuture[futures.size()];
                    CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(futuresArray));
                    try {
                        completableFuture.get(options.timeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException("Exception while processing put on backup owner", e.getCause());
                    }
                    catch (TimeoutException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
            }
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleNonTxWriteCommand(ctx, command);
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, Object key) throws Throwable {
        if (this.cdl.localNodeIsPrimaryOwner(key)) {
            this.localGetCacheEntry(ctx, key, true, command);
        }
    }

    private InternalCacheEntry localGetCacheEntry(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            this.wrapInternalCacheEntry(ice, ctx, key, isWrite, command);
            return ice;
        }
        return null;
    }

    private void wrapInternalCacheEntry(InternalCacheEntry ice, InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) {
        if (!ctx.replaceValue(key, ice)) {
            if (isWrite) {
                this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, true);
            } else {
                ctx.putLookedUpEntry(key, ice);
            }
        }
    }

    private <T extends FlagAffectedCommand & RemoteFetchingCommand> InternalCacheEntry remoteGetCacheEntry(InvocationContext ctx, Object key, T command) throws Throwable {
        if (trace) {
            log.tracef("Doing a remote get for key %s", key);
        }
        InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, false, command, false);
        ((RemoteFetchingCommand)command).setRemotelyFetchedValue(ice);
        return ice;
    }

    @Override
    protected boolean needValuesFromPreviousOwners(InvocationContext ctx, WriteCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER)) {
            return false;
        }
        if (command.hasFlag(Flag.DELTA_WRITE) && !command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return true;
        }
        if (this.isNeedReliableReturnValues(command) || command.isConditional()) {
            for (Object key : command.getAffectedKeys()) {
                if (!this.cdl.localNodeIsPrimaryOwner(key)) continue;
                return true;
            }
        }
        return false;
    }
}

