/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.jboss.marshalling.util.IdentityIntMap;

public class StreamMarshalling {
    private StreamMarshalling() {
    }

    public static Predicate<Object> equalityPredicate(Object object) {
        return new EqualityPredicate(object);
    }

    public static Predicate<Object> nonNullPredicate() {
        return NonNullPredicate.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return EntryToKeyFunction.getInstance();
    }

    public static <K, V> Function<Map.Entry<K, V>, V> entryToValueFunction() {
        return EntryToValueFunction.getInstance();
    }

    public static final class StreamMarshallingExternalizer
    implements AdvancedExternalizer<Object> {
        private static final int EQUALITY_PREDICATE = 0;
        private static final int ENTRY_KEY_FUNCTION = 1;
        private static final int ENTRY_VALUE_FUNCTION = 2;
        private static final int NON_NULL_PREDICATE = 3;
        private final IdentityIntMap<Class<? extends Object>> objects = new IdentityIntMap();

        public StreamMarshallingExternalizer() {
            this.objects.put(EqualityPredicate.class, 0);
            this.objects.put(EntryToKeyFunction.class, 1);
            this.objects.put(EntryToValueFunction.class, 2);
            this.objects.put(NonNullPredicate.class, 3);
        }

        public Set<Class<?>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{EqualityPredicate.class, EntryToKeyFunction.class, EntryToValueFunction.class, NonNullPredicate.class});
        }

        public Integer getId() {
            return 148;
        }

        public void writeObject(ObjectOutput output, Object object) throws IOException {
            int number = this.objects.get(object.getClass(), -1);
            output.writeByte(number);
            switch (number) {
                case 0: {
                    output.writeObject(((EqualityPredicate)object).object);
                }
            }
        }

        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int number = input.readUnsignedByte();
            switch (number) {
                case 0: {
                    return new EqualityPredicate(input.readObject());
                }
                case 1: {
                    return EntryToKeyFunction.getInstance();
                }
                case 2: {
                    return EntryToValueFunction.getInstance();
                }
                case 3: {
                    return NonNullPredicate.getInstance();
                }
            }
            throw new IllegalArgumentException("Found invalid number " + number);
        }
    }

    private static final class EntryToValueFunction<K, V>
    implements Function<Map.Entry<K, V>, V> {
        private static final EntryToValueFunction<?, ?> FUNCTION = new EntryToValueFunction();

        private EntryToValueFunction() {
        }

        public static <K, V> EntryToValueFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public V apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getValue();
        }
    }

    private static final class EntryToKeyFunction<K, V>
    implements Function<Map.Entry<K, V>, K> {
        private static final EntryToKeyFunction<?, ?> FUNCTION = new EntryToKeyFunction();

        private EntryToKeyFunction() {
        }

        public static <K, V> EntryToKeyFunction<K, V> getInstance() {
            return FUNCTION;
        }

        @Override
        public K apply(Map.Entry<K, V> kvEntry) {
            return kvEntry.getKey();
        }
    }

    private static final class NonNullPredicate
    implements Predicate<Object> {
        private static final NonNullPredicate INSTANCE = new NonNullPredicate();

        private NonNullPredicate() {
        }

        public static NonNullPredicate getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean test(Object t) {
            return t != null;
        }
    }

    private static final class EqualityPredicate
    implements Predicate<Object> {
        private final Object object;

        private EqualityPredicate(Object object) {
            Objects.nonNull(object);
            this.object = object;
        }

        @Override
        public boolean test(Object t) {
            return this.object.equals(t);
        }
    }
}

