/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.Iterator;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.impl.AbstractCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.DistributedIntCacheStream;
import org.infinispan.stream.impl.DistributedLongCacheStream;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.TerminalFunctions;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SkipDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SortedDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachDoubleOperation;
import org.infinispan.stream.impl.termop.primitive.ForEachFlatMapDoubleOperation;

public class DistributedDoubleCacheStream
extends AbstractCacheStream<Double, DoubleStream, DoubleConsumer>
implements DoubleStream {
    protected DistributedDoubleCacheStream(AbstractCacheStream other) {
        super(other);
    }

    @Override
    protected DoubleStream unwrap() {
        return this;
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        return this.addIntermediateOperation(new FilterDoubleOperation(predicate));
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        return this.addIntermediateOperation(new MapDoubleOperation(mapper));
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return this.addIntermediateOperationMap(new MapToObjDoubleOperation<U>(mapper), this.cacheStream());
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        return this.addIntermediateOperationMap(new MapToIntDoubleOperation(mapper), this.intCacheStream());
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        return this.addIntermediateOperationMap(new MapToLongDoubleOperation(mapper), this.longCacheStream());
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.iteratorOperation = AbstractCacheStream.IteratorOperation.FLAT_MAP;
        return this.addIntermediateOperation(new FlatMapDoubleOperation(mapper));
    }

    @Override
    public DoubleStream distinct() {
        DistinctDoubleOperation op = DistinctDoubleOperation.getInstance();
        this.markDistinct(op, AbstractCacheStream.IntermediateType.DOUBLE);
        return this.addIntermediateOperation(op);
    }

    @Override
    public DoubleStream sorted() {
        this.markSorted(AbstractCacheStream.IntermediateType.DOUBLE);
        return this.addIntermediateOperation(SortedDoubleOperation.getInstance());
    }

    @Override
    public DoubleStream peek(DoubleConsumer action) {
        return this.addIntermediateOperation(new PeekDoubleOperation(action));
    }

    @Override
    public DoubleStream limit(long maxSize) {
        LimitDoubleOperation op = new LimitDoubleOperation(maxSize);
        this.markDistinct(op, AbstractCacheStream.IntermediateType.DOUBLE);
        return this.addIntermediateOperation(op);
    }

    @Override
    public DoubleStream skip(long n) {
        SkipDoubleOperation op = new SkipDoubleOperation(n);
        this.markSkip(AbstractCacheStream.IntermediateType.DOUBLE);
        return this.addIntermediateOperation(op);
    }

    @Override
    public Stream<Double> boxed() {
        return this.addIntermediateOperationMap(BoxedDoubleOperation.getInstance(), this.cacheStream());
    }

    @Override
    public void forEach(DoubleConsumer action) {
        if (!this.rehashAware) {
            this.performOperation(TerminalFunctions.forEachFunction(action), false, (v1, v2) -> null, null);
        } else {
            this.performRehashForEach(action);
        }
    }

    @Override
    KeyTrackingTerminalOperation<Object, Double, Object> getForEach(DoubleConsumer consumer, Supplier<Stream<CacheEntry>> supplier) {
        if (this.iteratorOperation == AbstractCacheStream.IteratorOperation.FLAT_MAP) {
            return new ForEachFlatMapDoubleOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
        }
        return new ForEachDoubleOperation<Object>(this.intermediateOperations, supplier, this.distributedBatchSize, consumer);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            this.performIntermediateRemoteOperation(s -> {
                s.forEachOrdered(action);
                return null;
            });
        } else {
            this.forEach(action);
        }
    }

    @Override
    public double[] toArray() {
        return this.performOperation(TerminalFunctions.toArrayDoubleFunction(), false, (v1, v2) -> {
            double[] array = Arrays.copyOf(v1, ((double[])v1).length + ((double[])v2).length);
            System.arraycopy(v2, 0, array, ((double[])v1).length, ((double[])v2).length);
            return array;
        }, null, false);
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.performOperation(TerminalFunctions.reduceFunction(identity, op), true, (i1, i2) -> op.applyAsDouble((double)i1, (double)i2), null);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        Double result = this.performOperation(TerminalFunctions.reduceFunction(op), true, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return op.applyAsDouble((double)i1, (double)i2);
                }
                return i1;
            }
            return i2;
        }, null);
        if (result == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(result);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.performOperation(TerminalFunctions.collectFunction(supplier, accumulator, combiner), true, (e1, e2) -> {
            combiner.accept(e1, e2);
            return e1;
        }, null);
    }

    @Override
    public double sum() {
        return this.performOperation(TerminalFunctions.sumDoubleFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    @Override
    public OptionalDouble min() {
        Double value = this.performOperation(TerminalFunctions.minDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i2 : i1;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    @Override
    public OptionalDouble max() {
        Double value = this.performOperation(TerminalFunctions.maxDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                if (i2 != null) {
                    return i1 > i2 ? i1 : i2;
                }
                return i1;
            }
            return i2;
        }, null);
        if (value == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(value);
    }

    @Override
    public OptionalDouble average() {
        double[] results = this.performOperation(TerminalFunctions.averageDoubleFunction(), true, (a1, a2) -> {
            a1[0] = a1[0] + a2[0];
            a1[1] = a1[1] + a2[1];
            return a1;
        }, null);
        if (results[1] > 0.0) {
            return OptionalDouble.of(results[0] / results[1]);
        }
        return OptionalDouble.empty();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        PrimitiveIterator.OfDouble iterator = this.iterator();
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        iterator.forEachRemaining(i -> stats.accept(i));
        return stats;
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.anyMatchFunction(predicate), false, Boolean::logicalOr, b -> b);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.allMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return this.performOperation(TerminalFunctions.noneMatchFunction(predicate), false, Boolean::logicalAnd, b -> b == false);
    }

    @Override
    public OptionalDouble findFirst() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            return this.performIntermediateRemoteOperation(s -> s.findFirst());
        }
        return this.findAny();
    }

    @Override
    public OptionalDouble findAny() {
        Double result = this.performOperation(TerminalFunctions.findAnyDoubleFunction(), false, (i1, i2) -> {
            if (i1 != null) {
                return i1;
            }
            return i2;
        }, a -> a != null);
        if (result != null) {
            return OptionalDouble.of(result);
        }
        return OptionalDouble.empty();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        if (this.intermediateType.shouldUseIntermediate(this.sorted, this.distinct)) {
            DoubleStream stream = (DoubleStream)this.performIntermediateRemoteOperation(Function.identity());
            return stream.iterator();
        }
        return this.remoteIterator();
    }

    PrimitiveIterator.OfDouble remoteIterator() {
        this.intermediateOperations.add(BoxedDoubleOperation.getInstance());
        DistributedCacheStream stream = new DistributedCacheStream((AbstractCacheStream)this);
        Iterator<Double> iterator = stream.remoteIterator();
        return new DoubleIteratorToPrimiviteDouble(iterator);
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 0);
    }

    @Override
    public long count() {
        return this.performOperation(TerminalFunctions.countDoubleFunction(), true, (i1, i2) -> i1 + i2, null);
    }

    protected <R> DistributedCacheStream<R> cacheStream() {
        return new DistributedCacheStream((AbstractCacheStream)this);
    }

    protected DistributedIntCacheStream intCacheStream() {
        return new DistributedIntCacheStream((AbstractCacheStream)this);
    }

    protected DistributedLongCacheStream longCacheStream() {
        return new DistributedLongCacheStream((AbstractCacheStream)this);
    }

    static class DoubleIteratorToPrimiviteDouble
    implements PrimitiveIterator.OfDouble {
        private final Iterator<Double> iterator;

        DoubleIteratorToPrimiviteDouble(Iterator<Double> iterator) {
            this.iterator = iterator;
        }

        @Override
        public double nextDouble() {
            return this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

