/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.EntryVersionsMap;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int INITIAL_LOCK_CAPACITY = 4;
    protected volatile boolean hasLocalOnlyModifications;
    protected volatile List<WriteCommand> modifications;
    protected Map<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    protected volatile Set<Object> lockedKeys = null;
    protected volatile Set<Object> backupKeyLocks = null;
    private volatile boolean txComplete = false;
    protected final int topologyId;
    private EntryVersionsMap updatedEntryVersions;
    private EntryVersionsMap versionsSeenMap;
    private Map<Object, EntryVersion> lookedUpRemoteVersions;
    private volatile boolean isMarkedForRollback;
    private final long txCreationTime;
    protected final Equivalence<Object> keyEquivalence;
    private volatile Flag stateTransferFlag;
    private final CompletableFuture<Void> notifier;

    @Override
    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    @Override
    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public AbstractCacheTransaction(GlobalTransaction tx, int topologyId, Equivalence<Object> keyEquivalence, long txCreationTime) {
        this.tx = tx;
        this.topologyId = topologyId;
        this.keyEquivalence = keyEquivalence;
        this.txCreationTime = txCreationTime;
        this.notifier = new CompletableFuture();
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public final List<WriteCommand> getModifications() {
        if (this.hasLocalOnlyModifications) {
            return this.modifications.stream().filter(cmd -> !cmd.hasFlag(Flag.CACHE_MODE_LOCAL)).collect(Collectors.toList());
        }
        return this.getAllModifications();
    }

    @Override
    public final List<WriteCommand> getAllModifications() {
        return this.modifications == null ? InfinispanCollections.emptyList() : this.modifications;
    }

    public final void setModifications(List<WriteCommand> modifications) {
        if (modifications == null) {
            throw new IllegalArgumentException("modification list cannot be null");
        }
        ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>();
        for (WriteCommand cmd : modifications) {
            if (cmd.hasFlag(Flag.CACHE_MODE_LOCAL)) {
                this.hasLocalOnlyModifications = true;
            }
            mods.add(cmd);
        }
        this.modifications = Collections.synchronizedList(mods);
    }

    @Override
    public final boolean hasModification(Class<?> modificationClass) {
        if (this.modifications != null) {
            for (WriteCommand mod : this.getModifications()) {
                if (!modificationClass.isAssignableFrom(mod.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        return this.getLockedKeys().contains(key);
    }

    @Override
    public void notifyOnTransactionFinished() {
        if (trace) {
            log.tracef("Transaction %s has completed, notifying listening threads.", this.tx);
        }
        if (!this.txComplete) {
            this.txComplete = true;
            this.notifier.complete(null);
        }
    }

    @Override
    public final boolean waitForLockRelease(long lockAcquisitionTimeout) throws InterruptedException {
        try {
            this.notifier.get(lockAcquisitionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Should never happen", e);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return this.txComplete;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void addBackupLockForKey(Object key) {
        if (this.backupKeyLocks == null) {
            this.backupKeyLocks = Collections.synchronizedSet(new HashSet(4));
        }
        this.backupKeyLocks.add(key);
    }

    public void registerLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = Collections.synchronizedSet(CollectionFactory.makeSet((int)4, this.keyEquivalence));
        }
        if (trace) {
            log.tracef("Registering locked key: %s", Util.toStr((Object)key));
        }
        this.lockedKeys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? InfinispanCollections.emptySet() : this.lockedKeys;
    }

    @Override
    public Set<Object> getBackupLockedKeys() {
        return this.backupKeyLocks == null ? InfinispanCollections.emptySet() : this.backupKeyLocks;
    }

    @Override
    public void clearLockedKeys() {
        if (trace) {
            log.tracef("Clearing locked keys: %s", Util.toStr(this.lockedKeys));
        }
        this.lockedKeys = null;
    }

    @Override
    public boolean containsLockOrBackupLock(Object key) {
        return this.getLockedKeys().contains(key) || this.getBackupLockedKeys().contains(key);
    }

    @Override
    public Object findAnyLockedOrBackupLocked(Collection<Object> keys) {
        Set<Object> lockedKeysCopy = this.getLockedKeys();
        Set<Object> backupKeyLocksCopy = this.getBackupLockedKeys();
        for (Object key : keys) {
            if (!lockedKeysCopy.contains(key) && !backupKeyLocksCopy.contains(key)) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean areLocksReleased() {
        return this.txComplete;
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? InfinispanCollections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<?> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = CollectionFactory.makeSet((int)4, this.keyEquivalence);
        }
    }

    @Override
    public EntryVersionsMap getUpdatedEntryVersions() {
        return this.updatedEntryVersions;
    }

    @Override
    public void setUpdatedEntryVersions(EntryVersionsMap updatedEntryVersions) {
        this.updatedEntryVersions = updatedEntryVersions;
    }

    @Override
    public EntryVersion getLookedUpRemoteVersion(Object key) {
        return this.lookedUpRemoteVersions != null ? this.lookedUpRemoteVersions.get(key) : null;
    }

    @Override
    public void putLookedUpRemoteVersion(Object key, EntryVersion version) {
        if (this.lookedUpRemoteVersions == null) {
            this.lookedUpRemoteVersions = new HashMap<Object, EntryVersion>();
        }
        this.lookedUpRemoteVersions.put(key, version);
    }

    @Override
    public void addReadKey(Object key) {
    }

    @Override
    public boolean keyRead(Object key) {
        return false;
    }

    @Override
    public void addVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new EntryVersionsMap();
        }
        if (!this.versionsSeenMap.containsKey(key)) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction %s read %s with version %s", this.getGlobalTransaction().globalId(), key, version);
            }
            this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        }
    }

    @Override
    public void replaceVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new EntryVersionsMap();
        }
        EntryVersion oldVersion = this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        if (log.isTraceEnabled()) {
            log.tracef("Transaction %s replaced version for key %s. old=%s, new=%s", new Object[]{this.getGlobalTransaction().globalId(), key, oldVersion, version});
        }
    }

    @Override
    public EntryVersionsMap getVersionsRead() {
        return this.versionsSeenMap == null ? new EntryVersionsMap() : this.versionsSeenMap;
    }

    public final boolean isFromStateTransfer() {
        return this.stateTransferFlag != null;
    }

    public final Flag getStateTransferFlag() {
        return this.stateTransferFlag;
    }

    public abstract void setStateTransferFlag(Flag var1);

    protected final void internalSetStateTransferFlag(Flag stateTransferFlag) {
        this.stateTransferFlag = stateTransferFlag;
    }

    @Override
    public long getCreationTime() {
        return this.txCreationTime;
    }

    @Override
    public final void addListener(CacheTransaction.TransactionCompletedListener listener) {
        this.notifier.thenRun(listener::onCompletion);
    }
}

