/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.saml2.core.Assertion;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public class AssertionSchemaValidator
implements Validator<Assertion> {
    public void validate(Assertion assertion) throws ValidationException {
        this.validateIssuer(assertion);
        this.validateVersion(assertion);
        this.validateID(assertion);
        this.validateIssueInstant(assertion);
    }

    protected void validateIssuer(Assertion assertion) throws ValidationException {
        if (assertion.getIssuer() == null) {
            throw new ValidationException("Issuer is required element");
        }
    }

    protected void validateVersion(Assertion assertion) throws ValidationException {
        if (assertion.getVersion() == null) {
            throw new ValidationException("Version is required attribute");
        }
    }

    protected void validateID(Assertion assertion) throws ValidationException {
        if (DatatypeHelper.isEmpty((String)assertion.getID())) {
            throw new ValidationException("ID is required attribute");
        }
    }

    protected void validateIssueInstant(Assertion assertion) throws ValidationException {
        if (assertion.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant is required attribute");
        }
    }
}

