/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.util.Collections;
import java.util.Properties;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerlinDevice
extends Merlin {
    private static final Logger LOG = LoggerFactory.getLogger(MerlinDevice.class);
    private static final boolean DO_DEBUG = LOG.isDebugEnabled();

    public MerlinDevice() {
    }

    public MerlinDevice(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        super(properties, loader, passwordEncryptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void loadProperties(Properties properties, ClassLoader loader, PasswordEncryptor passwordEncryptor) throws WSSecurityException, IOException {
        if (properties == null) {
            return;
        }
        this.properties = properties;
        this.passwordEncryptor = passwordEncryptor;
        prefix = "org.apache.wss4j.crypto.merlin.";
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            propKey = (String)key;
            if (propKey.startsWith("org.apache.wss4j.crypto.merlin.")) break;
            if (!propKey.startsWith("org.apache.ws.security.crypto.merlin.")) continue;
            prefix = "org.apache.ws.security.crypto.merlin.";
            break;
        }
        if ((provider = properties.getProperty(prefix + "keystore.provider")) != null) {
            provider = provider.trim();
        }
        if ((certProvider = properties.getProperty(prefix + "cert.provider")) != null) {
            this.setCryptoProvider(certProvider);
        }
        if ((alias = properties.getProperty(prefix + "keystore.alias")) != null) {
            this.defaultAlias = alias = alias.trim();
        }
        if ((keyStoreLocation = properties.getProperty(prefix + "keystore.file")) == null) {
            keyStoreLocation = properties.getProperty(prefix + "file");
        }
        if ((keyStorePassword = properties.getProperty(prefix + "keystore.password", "security")) != null) {
            keyStorePassword = keyStorePassword.trim();
            keyStorePassword = this.decryptPassword(keyStorePassword, passwordEncryptor);
        }
        if ((keyStoreType = properties.getProperty(prefix + "keystore.type", KeyStore.getDefaultType())) != null) {
            keyStoreType = keyStoreType.trim();
        }
        if (keyStoreLocation != null) {
            keyStoreLocation = keyStoreLocation.trim();
            is = MerlinDevice.loadInputStream(loader, keyStoreLocation);
            try {
                this.keystore = this.load(is, keyStorePassword, provider, keyStoreType);
                if (!MerlinDevice.DO_DEBUG) ** GOTO lbl39
                MerlinDevice.LOG.debug("The KeyStore " + keyStoreLocation + " of type " + keyStoreType + " has been loaded");
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            this.keystore = this.load(null, keyStorePassword, provider, keyStoreType);
        }
lbl39:
        // 3 sources

        if ((trustStorePassword = properties.getProperty(prefix + "truststore.password", "changeit")) != null) {
            trustStorePassword = trustStorePassword.trim();
            trustStorePassword = this.decryptPassword(trustStorePassword, passwordEncryptor);
        }
        if ((trustStoreType = properties.getProperty(prefix + "truststore.type", KeyStore.getDefaultType())) != null) {
            trustStoreType = trustStoreType.trim();
        }
        if ((loadCacerts = properties.getProperty(prefix + "load.cacerts", "false")) != null) {
            loadCacerts = loadCacerts.trim();
        }
        if ((trustStoreLocation = properties.getProperty(prefix + "truststore.file")) != null) {
            trustStoreLocation = trustStoreLocation.trim();
            is = MerlinDevice.loadInputStream(loader, trustStoreLocation);
            try {
                this.truststore = this.load(is, trustStorePassword, provider, trustStoreType);
                if (MerlinDevice.DO_DEBUG) {
                    MerlinDevice.LOG.debug("The TrustStore " + trustStoreLocation + " of type " + trustStoreType + " has been loaded");
                }
                this.loadCACerts = false;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else if (Boolean.valueOf(loadCacerts).booleanValue()) {
            cacertsPath = System.getProperty("java.home") + "/lib/security/cacerts";
            if (cacertsPath != null) {
                cacertsPath = cacertsPath.trim();
            }
            is = new FileInputStream(cacertsPath);
            try {
                cacertsPasswd = properties.getProperty(prefix + "truststore.password", "changeit");
                if (cacertsPasswd != null) {
                    cacertsPasswd = cacertsPasswd.trim();
                    cacertsPasswd = this.decryptPassword(cacertsPasswd, passwordEncryptor);
                }
                this.truststore = this.load(is, cacertsPasswd, null, KeyStore.getDefaultType());
                if (MerlinDevice.DO_DEBUG) {
                    MerlinDevice.LOG.debug("CA certs have been loaded");
                }
                this.loadCACerts = true;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            this.truststore = this.load(null, trustStorePassword, provider, trustStoreType);
        }
        if ((crlLocation = properties.getProperty(prefix + "x509crl.file")) != null) {
            crlLocation = crlLocation.trim();
            is = MerlinDevice.loadInputStream(loader, crlLocation);
            try {
                cf = this.getCertificateFactory();
                crl = (X509CRL)cf.generateCRL(is);
                this.crlCertStore = provider == null || provider.length() == 0 ? CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl))) : CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Collections.singletonList(crl)), provider);
                if (MerlinDevice.DO_DEBUG) {
                    MerlinDevice.LOG.debug("The CRL " + crlLocation + " has been loaded");
                }
            }
            catch (Exception e) {
                if (MerlinDevice.DO_DEBUG) {
                    MerlinDevice.LOG.debug(e.getMessage(), (Throwable)e);
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "ioError00", e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

