/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.idp;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.picketlink.common.model.ModelElement;
import org.wildfly.extension.picketlink.federation.Namespace;
import org.wildfly.extension.picketlink.federation.model.AbstractFederationResourceDefinition;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainAddHandler;
import org.wildfly.extension.picketlink.federation.model.idp.TrustDomainRemoveHandler;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class TrustDomainResourceDefinition
extends AbstractFederationResourceDefinition {
    public static final SimpleAttributeDefinition CERT_ALIAS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_CERT_ALIAS.getName(), ModelType.STRING, true).setAllowExpression(true)).setDeprecated(Namespace.PICKETLINK_FEDERATION_2_0.getModelVersion())).build();
    public static final TrustDomainResourceDefinition INSTANCE = new TrustDomainResourceDefinition();

    private TrustDomainResourceDefinition() {
        super(ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN, (OperationStepHandler)TrustDomainAddHandler.INSTANCE, (OperationStepHandler)TrustDomainRemoveHandler.INSTANCE, CERT_ALIAS);
    }

    @Override
    protected OperationStepHandler createAttributeWriterHandler() {
        List<SimpleAttributeDefinition> attributes = this.getAttributes();
        return new ReloadRequiredWriteAttributeHandler(attributes.toArray(new AttributeDefinition[attributes.size()])){

            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                TrustDomainResourceDefinition.validateModelInOperation(context, model.getModel());
                super.validateUpdatedModel(context, model);
            }
        };
    }

    public static void validateModelInOperation(OperationContext context, ModelNode model) throws OperationFailedException {
        String certAliasAttribName = ModelElement.IDENTITY_PROVIDER_TRUST_DOMAIN_CERT_ALIAS.getName();
        if (context.getProcessType().isServer() && model.hasDefined(certAliasAttribName)) {
            throw PicketLinkLogger.ROOT_LOGGER.attributeNoLongerSupported(certAliasAttribName);
        }
    }
}

