/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;

public final class ReadWriteKeyValueCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    public static final byte COMMAND_ID = 51;
    private V value;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;

    public ReadWriteKeyValueCommand(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id) {
        super(key, f.getClass().getAnnotation(SerializeWith.class), id);
        this.value = value;
        this.f = f;
    }

    public ReadWriteKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 51;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 51) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.value = parameters[1];
        this.f = (BiFunction)parameters[2];
        this.valueMatcher = (ValueMatcher)((Object)parameters[3]);
        this.flags = (Set)parameters[4];
        this.commandInvocationId = (CommandInvocationId)parameters[5];
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value, this.f, this.valueMatcher, Flag.copyWithoutRemotableFlags(this.flags), this.commandInvocationId};
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        return this.f.apply(this.value, EntryViews.readWrite(e, this.notifier));
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public String toString() {
        return super.toString() + "@" + Util.hexIdHashCode((Object)this);
    }
}

