/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.FunctionalMap;
import org.infinispan.commons.api.functional.Param;
import org.infinispan.commons.api.functional.Traversable;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.WaitModes;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ReadOnlyMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.ReadOnlyMap<K, V> {
    private static final Log log = LogFactory.getLog(ReadOnlyMapImpl.class);
    private final Params params;

    private ReadOnlyMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(functionalMap);
        this.params = params;
    }

    public static <K, V> FunctionalMap.ReadOnlyMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return new ReadOnlyMapImpl<K, V>(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.ReadOnlyMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new ReadOnlyMapImpl<K, V>(params, functionalMap);
    }

    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        Param waitMode = this.params.get(0);
        ReadOnlyKeyCommand cmd = this.fmap.cmdFactory().buildReadOnlyKeyCommand(key, f);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(false, 1);
        return WaitModes.withWaitFuture(waitMode, this.fmap.asyncExec(), () -> this.fmap.chain().invoke(ctx, cmd));
    }

    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(m=%s, %s)", keys, this.params);
        Param waitMode = this.params.get(0);
        ReadOnlyManyCommand cmd = this.fmap.cmdFactory().buildReadOnlyManyCommand(keys, f);
        InvocationContext ctx = this.fmap.invCtxFactory().createInvocationContext(false, keys.size());
        return WaitModes.withWaitTraversable(waitMode, () -> (Stream)this.fmap.chain().invoke(ctx, cmd));
    }

    public Traversable<K> keys() {
        log.tracef("Invoked keys(%s)", this.params);
        Param waitMode = this.params.get(0);
        return WaitModes.withWaitTraversable(waitMode, () -> this.fmap.cache.keySet().stream());
    }

    public Traversable<EntryView.ReadEntryView<K, V>> entries() {
        log.tracef("Invoked entries(%s)", this.params);
        Param waitMode = this.params.get(0);
        CloseableIterator it = this.fmap.cache.filterEntries(AcceptAllKeyValueFilter.getInstance()).iterator();
        Stream stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1024), false);
        return WaitModes.withWaitTraversable(waitMode, () -> stream.map(EntryViews::readOnly));
    }

    public FunctionalMap.ReadOnlyMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return ReadOnlyMapImpl.create(this.params.addAll(ps), this.fmap);
    }
}

