/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.api.functional.MetaParam;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeValueMatcher;
import org.infinispan.commons.marshall.SerializeWith;

public final class MarshallableFunctionalInterfaces {
    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> setValueReturnPrevOrNull() {
        return SetValueReturnPrevOrNull.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> setValueIfAbsentReturnPrevOrNull() {
        return SetValueIfAbsentReturnPrevOrNull.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> setValueIfAbsentReturnBoolean() {
        return SetValueIfAbsentReturnBoolean.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> setValueIfPresentReturnPrevOrNull() {
        return SetValueIfPresentReturnPrevOrNull.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> setValueIfPresentReturnBoolean() {
        return SetValueIfPresentReturnBoolean.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> setValueIfEqualsReturnBoolean(V oldValue) {
        return new SetValueIfEqualsReturnBoolean(oldValue);
    }

    public static <K, V> Function<EntryView.ReadWriteEntryView<K, V>, V> removeReturnPrevOrNull() {
        return RemoveReturnPrevOrNull.INSTANCE;
    }

    public static <K, V> Function<EntryView.ReadWriteEntryView<K, V>, Boolean> removeReturnBoolean() {
        return RemoveReturnBoolean.INSTANCE;
    }

    public static <K, V> BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> removeIfValueEqualsReturnBoolean() {
        return RemoveIfValueEqualsReturnBoolean.INSTANCE;
    }

    public static <V> BiConsumer<V, EntryView.WriteEntryView<V>> setValueConsumer() {
        return SetValue.INSTANCE;
    }

    public static <V> Consumer<EntryView.WriteEntryView<V>> removeConsumer() {
        return Remove.INSTANCE;
    }

    public static <K, V> Function<EntryView.ReadWriteEntryView<K, V>, Optional<V>> findReadWrite() {
        return FindReadWrite.INSTANCE;
    }

    public static <K, V> Function<EntryView.ReadWriteEntryView<K, V>, V> getReadWrite() {
        return GetReadWrite.INSTANCE;
    }

    private MarshallableFunctionalInterfaces() {
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class GetReadWrite<K, V>
    implements Function<EntryView.ReadWriteEntryView<K, V>, V> {
        private static final GetReadWrite INSTANCE = new GetReadWrite();

        private GetReadWrite() {
        }

        @Override
        public V apply(EntryView.ReadWriteEntryView<K, V> rw) {
            return (V)rw.get();
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class FindReadWrite<K, V>
    implements Function<EntryView.ReadWriteEntryView<K, V>, Optional<V>> {
        private static final FindReadWrite INSTANCE = new FindReadWrite();

        private FindReadWrite() {
        }

        @Override
        public Optional<V> apply(EntryView.ReadWriteEntryView<K, V> rw) {
            return rw.find();
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class Remove<V>
    implements Consumer<EntryView.WriteEntryView<V>> {
        private static final Remove INSTANCE = new Remove();

        private Remove() {
        }

        @Override
        public void accept(EntryView.WriteEntryView<V> wo) {
            wo.remove();
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class)
    private static final class SetValue<V>
    implements BiConsumer<V, EntryView.WriteEntryView<V>> {
        private static final SetValue INSTANCE = new SetValue();

        private SetValue() {
        }

        @Override
        public void accept(V v, EntryView.WriteEntryView<V> wo) {
            wo.set(v, new MetaParam.Writable[0]);
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_EXPECTED)
    private static final class RemoveIfValueEqualsReturnBoolean<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> {
        private static final RemoveIfValueEqualsReturnBoolean INSTANCE = new RemoveIfValueEqualsReturnBoolean();

        private RemoveIfValueEqualsReturnBoolean() {
        }

        @Override
        public Boolean apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            return rw.find().map(prev -> {
                if (prev.equals(v)) {
                    rw.remove();
                    return true;
                }
                return false;
            }).orElse(false);
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_ALWAYS)
    private static final class RemoveReturnBoolean<K, V>
    implements Function<EntryView.ReadWriteEntryView<K, V>, Boolean> {
        private static final RemoveReturnBoolean INSTANCE = new RemoveReturnBoolean();

        private RemoveReturnBoolean() {
        }

        @Override
        public Boolean apply(EntryView.ReadWriteEntryView<K, V> rw) {
            boolean success = rw.find().isPresent();
            rw.remove();
            return success;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_ALWAYS)
    private static final class RemoveReturnPrevOrNull<K, V>
    implements Function<EntryView.ReadWriteEntryView<K, V>, V> {
        private static final RemoveReturnPrevOrNull INSTANCE = new RemoveReturnPrevOrNull();

        private RemoveReturnPrevOrNull() {
        }

        @Override
        public V apply(EntryView.ReadWriteEntryView<K, V> rw) {
            V prev = rw.find().orElse(null);
            rw.remove();
            return prev;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_EXPECTED)
    private static final class SetValueIfEqualsReturnBoolean<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> {
        private final V oldValue;

        public SetValueIfEqualsReturnBoolean(V oldValue) {
            this.oldValue = oldValue;
        }

        @Override
        public Boolean apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            return rw.find().map(prev -> {
                if (prev.equals(this.oldValue)) {
                    rw.set(v, new MetaParam.Writable[0]);
                    return true;
                }
                return false;
            }).orElse(false);
        }

        public static final class Externalizer0
        implements Externalizer<SetValueIfEqualsReturnBoolean<?, ?>> {
            public void writeObject(ObjectOutput oo, SetValueIfEqualsReturnBoolean<?, ?> o) throws IOException {
                oo.writeObject(((SetValueIfEqualsReturnBoolean)o).oldValue);
            }

            public SetValueIfEqualsReturnBoolean<?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                Object oldValue = input.readObject();
                return new SetValueIfEqualsReturnBoolean(oldValue);
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_NON_NULL)
    private static final class SetValueIfPresentReturnBoolean<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> {
        private static final SetValueIfPresentReturnBoolean INSTANCE = new SetValueIfPresentReturnBoolean();

        private SetValueIfPresentReturnBoolean() {
        }

        @Override
        public Boolean apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            return rw.find().map(prev -> {
                rw.set(v, new MetaParam.Writable[0]);
                return true;
            }).orElse(false);
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_NON_NULL)
    private static final class SetValueIfPresentReturnPrevOrNull<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> {
        private static final SetValueIfPresentReturnPrevOrNull INSTANCE = new SetValueIfPresentReturnPrevOrNull();

        private SetValueIfPresentReturnPrevOrNull() {
        }

        @Override
        public V apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            return rw.find().map(prev -> {
                rw.set(v, new MetaParam.Writable[0]);
                return prev;
            }).orElse(null);
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_EXPECTED)
    private static final class SetValueIfAbsentReturnBoolean<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, Boolean> {
        private static final SetValueIfAbsentReturnBoolean INSTANCE = new SetValueIfAbsentReturnBoolean();

        private SetValueIfAbsentReturnBoolean() {
        }

        @Override
        public Boolean apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            boolean success;
            Optional opt = rw.find();
            boolean bl = success = !opt.isPresent();
            if (success) {
                rw.set(v, new MetaParam.Writable[0]);
            }
            return success;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_EXPECTED)
    private static final class SetValueIfAbsentReturnPrevOrNull<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> {
        private static final SetValueIfAbsentReturnPrevOrNull INSTANCE = new SetValueIfAbsentReturnPrevOrNull();

        private SetValueIfAbsentReturnPrevOrNull() {
        }

        @Override
        public V apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            Optional opt = rw.find();
            V prev = opt.orElse(null);
            if (!opt.isPresent()) {
                rw.set(v, new MetaParam.Writable[0]);
            }
            return prev;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }

    @SerializeWith(value=Externalizer0.class, valueMatcher=SerializeValueMatcher.MATCH_ALWAYS)
    private static final class SetValueReturnPrevOrNull<K, V>
    implements BiFunction<V, EntryView.ReadWriteEntryView<K, V>, V> {
        private static final SetValueReturnPrevOrNull INSTANCE = new SetValueReturnPrevOrNull();

        private SetValueReturnPrevOrNull() {
        }

        @Override
        public V apply(V v, EntryView.ReadWriteEntryView<K, V> rw) {
            V prev = rw.find().orElse(null);
            rw.set(v, new MetaParam.Writable[0]);
            return prev;
        }

        public static final class Externalizer0
        implements Externalizer<Object> {
            public void writeObject(ObjectOutput oo, Object o) {
            }

            public Object readObject(ObjectInput input) {
                return INSTANCE;
            }
        }
    }
}

