/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.modules.Module;
import org.wildfly.extension.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.extension.undertow.session.SharedSessionManagerConfig;

public class SimpleDistributableSessionManagerConfiguration
implements DistributableSessionManagerConfiguration {
    private final Integer maxActiveSessions;
    private final ReplicationConfig replicationConfig;
    private final String deploymentName;
    private final Module module;

    public SimpleDistributableSessionManagerConfiguration(JBossWebMetaData metaData, String deploymentName, Module module) {
        this(metaData.getMaxActiveSessions(), metaData.getReplicationConfig(), deploymentName, module);
    }

    public SimpleDistributableSessionManagerConfiguration(SharedSessionManagerConfig config, String deploymentName, Module module) {
        this(config.getMaxActiveSessions(), config.getReplicationConfig(), deploymentName, module);
    }

    private SimpleDistributableSessionManagerConfiguration(Integer maxActiveSessions, ReplicationConfig replicationConfig, String deploymentName, Module module) {
        this.maxActiveSessions = maxActiveSessions;
        this.replicationConfig = replicationConfig;
        this.deploymentName = deploymentName;
        this.module = module;
    }

    @Override
    public int getMaxActiveSessions() {
        return this.maxActiveSessions != null ? this.maxActiveSessions : -1;
    }

    @Override
    public ReplicationGranularity getGranularity() {
        return this.replicationConfig != null && this.replicationConfig.getReplicationGranularity() != null ? this.replicationConfig.getReplicationGranularity() : ReplicationGranularity.SESSION;
    }

    @Override
    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public String getCacheName() {
        return this.replicationConfig != null ? this.replicationConfig.getCacheName() : null;
    }
}

