/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SAXMessageFormatter {
    public static String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        String msg2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.SAXMessages", locale);
        try {
            msg2 = resourceBundle.getString(key);
            if (arguments != null) {
                try {
                    msg2 = MessageFormat.format(msg2, arguments);
                }
                catch (Exception e) {
                    msg2 = resourceBundle.getString("FormatFailed");
                    msg2 = msg2 + " " + resourceBundle.getString(key);
                }
            }
        }
        catch (MissingResourceException e) {
            String msg2 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(key, msg2, key);
        }
        if (msg2 == null) {
            msg2 = key;
            if (arguments.length > 0) {
                StringBuffer str = new StringBuffer(msg2);
                str.append('?');
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        str.append('&');
                    }
                    str.append(String.valueOf(arguments[i]));
                }
            }
        }
        return msg2;
    }
}

