/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr.annotated;

import io.undertow.UndertowLogger;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.jsr.OrderedExecutor;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.annotated.BoundMethod;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;

public class AnnotatedEndpoint
extends Endpoint {
    private final InstanceHandle<?> instance;
    private Executor executor;
    private final BoundMethod webSocketOpen;
    private final BoundMethod webSocketClose;
    private final BoundMethod webSocketError;
    private final BoundMethod textMessage;
    private final BoundMethod binaryMessage;
    private final BoundMethod pongMessage;
    private volatile boolean released;

    AnnotatedEndpoint(InstanceHandle<?> instance, BoundMethod webSocketOpen, BoundMethod webSocketClose, BoundMethod webSocketError, BoundMethod textMessage, BoundMethod binaryMessage, BoundMethod pongMessage) {
        this.instance = instance;
        this.webSocketOpen = webSocketOpen;
        this.webSocketClose = webSocketClose;
        this.webSocketError = webSocketError;
        this.textMessage = textMessage;
        this.binaryMessage = binaryMessage;
        this.pongMessage = pongMessage;
    }

    public void onOpen(Session session, EndpointConfig endpointConfiguration) {
        boolean partialBinary;
        this.released = false;
        this.executor = new OrderedExecutor((Executor)((UndertowSession)session).getWebSocketChannel().getWorker());
        UndertowSession s = (UndertowSession)session;
        boolean partialText = this.textMessage == null || this.textMessage.hasParameterType(Boolean.TYPE) && !this.textMessage.getMessageType().equals(Boolean.TYPE);
        boolean bl = partialBinary = this.binaryMessage == null || this.binaryMessage.hasParameterType(Boolean.TYPE) && !this.binaryMessage.getMessageType().equals(Boolean.TYPE);
        if (this.textMessage != null) {
            if (partialText) {
                this.addPartialHandler(s, this.textMessage);
            } else {
                if (this.textMessage.getMaxMessageSize() > 0L) {
                    s.setMaxTextMessageBufferSize((int)this.textMessage.getMaxMessageSize());
                }
                this.addWholeHandler(s, this.textMessage);
            }
        }
        if (this.binaryMessage != null) {
            if (partialBinary) {
                this.addPartialHandler(s, this.binaryMessage);
            } else {
                if (this.binaryMessage.getMaxMessageSize() > 0L) {
                    s.setMaxBinaryMessageBufferSize((int)this.binaryMessage.getMaxMessageSize());
                }
                this.addWholeHandler(s, this.binaryMessage);
            }
        }
        if (this.pongMessage != null) {
            this.addWholeHandler(s, this.pongMessage);
        }
        if (this.webSocketOpen != null) {
            HashMap params = new HashMap();
            params.put(Session.class, session);
            params.put(EndpointConfig.class, endpointConfiguration);
            params.put(Map.class, session.getPathParameters());
            this.invokeMethod(params, this.webSocketOpen, s);
        }
    }

    private void addPartialHandler(final UndertowSession session, final BoundMethod method) {
        session.addMessageHandler(method.getMessageType(), new MessageHandler.Partial<Object>(){

            public void onMessage(Object partialMessage, boolean last) {
                final HashMap params = new HashMap();
                params.put(Session.class, session);
                params.put(Map.class, session.getPathParameters());
                params.put(method.getMessageType(), partialMessage);
                params.put(Boolean.TYPE, last);
                session.getContainer().invokeEndpointMethod(new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        try {
                            result = method.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            AnnotatedEndpoint.this.onError(session, e);
                            return;
                        }
                        AnnotatedEndpoint.this.sendResult(result, session);
                    }
                });
            }
        });
    }

    private void addWholeHandler(final UndertowSession session, final BoundMethod method) {
        session.addMessageHandler(method.getMessageType(), new MessageHandler.Whole<Object>(){

            public void onMessage(Object partialMessage) {
                final HashMap params = new HashMap();
                params.put(Session.class, session);
                params.put(Map.class, session.getPathParameters());
                params.put(method.getMessageType(), partialMessage);
                session.getContainer().invokeEndpointMethod(new Runnable(){

                    @Override
                    public void run() {
                        Object result;
                        try {
                            result = method.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            AnnotatedEndpoint.this.onError(session, e);
                            return;
                        }
                        AnnotatedEndpoint.this.sendResult(result, session);
                    }
                });
            }
        });
    }

    private void invokeMethod(final Map<Class<?>, Object> params, final BoundMethod method, final UndertowSession session) {
        session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                if (!AnnotatedEndpoint.this.released) {
                    try {
                        method.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                    }
                    catch (Exception e) {
                        AnnotatedEndpoint.this.onError(session, e);
                    }
                }
            }
        });
    }

    private void sendResult(Object result, UndertowSession session) {
        if (result != null) {
            if (result instanceof String) {
                session.getAsyncRemote().sendText((String)result, (SendHandler)new ErrorReportingSendHandler(session));
            } else if (result instanceof byte[]) {
                session.getAsyncRemote().sendBinary(ByteBuffer.wrap((byte[])result), (SendHandler)new ErrorReportingSendHandler(session));
            } else if (result instanceof ByteBuffer) {
                session.getAsyncRemote().sendBinary((ByteBuffer)result, (SendHandler)new ErrorReportingSendHandler(session));
            } else {
                session.getAsyncRemote().sendObject(result, (SendHandler)new ErrorReportingSendHandler(session));
            }
        }
    }

    public void onClose(final Session session, CloseReason closeReason) {
        if (this.webSocketClose != null) {
            final HashMap<Class<CloseReason>, Object> params = new HashMap<Class<CloseReason>, Object>();
            params.put(Session.class, session);
            params.put(Map.class, session.getPathParameters());
            params.put(CloseReason.class, closeReason);
            ((UndertowSession)session).getContainer().invokeEndpointMethod(this.executor, new Runnable(){

                @Override
                public void run() {
                    if (!AnnotatedEndpoint.this.released) {
                        try {
                            AnnotatedEndpoint.this.webSocketClose.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            AnnotatedEndpoint.this.onError(session, e);
                        }
                        finally {
                            AnnotatedEndpoint.this.released = true;
                            AnnotatedEndpoint.this.instance.release();
                        }
                    }
                }
            });
        }
    }

    public void onError(Session session, Throwable thr) {
        if (this.webSocketError != null) {
            final HashMap<Class<Map>, Object> params = new HashMap<Class<Map>, Object>();
            params.put(Session.class, session);
            params.put(Throwable.class, thr);
            params.put(Map.class, session.getPathParameters());
            ((UndertowSession)session).getContainer().invokeEndpointMethod(this.executor, new Runnable(){

                @Override
                public void run() {
                    if (!AnnotatedEndpoint.this.released) {
                        try {
                            AnnotatedEndpoint.this.webSocketError.invoke(AnnotatedEndpoint.this.instance.getInstance(), params);
                        }
                        catch (Exception e) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        } else if (thr instanceof IOException) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException((IOException)thr);
        } else {
            WebSocketLogger.REQUEST_LOGGER.unhandledErrorInAnnotatedEndpoint(this.instance.getInstance(), thr);
        }
    }

    private final class ErrorReportingSendHandler
    implements SendHandler {
        private final Session session;

        private ErrorReportingSendHandler(Session session) {
            this.session = session;
        }

        public void onResult(SendResult result) {
            if (!result.isOK()) {
                AnnotatedEndpoint.this.onError(this.session, result.getException());
            }
        }
    }
}

