/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote;

import java.security.PrivilegedAction;
import java.util.Arrays;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ProtobufMatcher;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.remote.CompatibilityReflectionMatcher;
import org.infinispan.query.remote.ProtobufIndexedFieldProvider;
import org.infinispan.query.remote.QueryFacadeImpl;
import org.infinispan.query.remote.SecurityActions;
import org.infinispan.query.remote.filter.JPAProtobufFilterAndConverter;
import org.infinispan.query.remote.indexing.IndexingMetadata;
import org.infinispan.query.remote.indexing.ProtobufValueWrapper;
import org.infinispan.query.remote.logging.Log;

final class RemoteQueryEngine
extends QueryEngine {
    private static final Log log = (Log)LogFactory.getLog(QueryFacadeImpl.class, Log.class);
    private final boolean isCompatMode;
    private final SerializationContext serCtx;

    public RemoteQueryEngine(AdvancedCache<?, ?> cache, SearchManager searchManager, boolean isCompatMode, SerializationContext serCtx) {
        super(cache, searchManager);
        this.isCompatMode = isCompatMode;
        this.serCtx = serCtx;
    }

    protected BaseMatcher getFirstPhaseMatcher() {
        Class matcherImplClass = this.isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class;
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(matcherImplClass);
    }

    protected BaseMatcher getSecondPhaseMatcher() {
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(ProtobufMatcher.class);
    }

    protected Query makeTypeQuery(Query query, String targetEntityName) {
        if (this.isCompatMode) {
            return query;
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add(new BooleanClause((Query)new TermQuery(new Term("$type$", targetEntityName)), BooleanClause.Occur.MUST));
        booleanQuery.add(new BooleanClause(query, BooleanClause.Occur.MUST));
        return booleanQuery;
    }

    protected JPAFilterAndConverter makeFilter(final String jpaQuery) {
        return SecurityActions.doPrivileged(new PrivilegedAction<JPAFilterAndConverter>(){

            @Override
            public JPAFilterAndConverter run() {
                JPAProtobufFilterAndConverter filter = RemoteQueryEngine.this.searchManager != null && !RemoteQueryEngine.this.isCompatMode ? new JPAProtobufFilterAndConverter(jpaQuery) : new JPAFilterAndConverter(jpaQuery, RemoteQueryEngine.this.isCompatMode ? CompatibilityReflectionMatcher.class : ProtobufMatcher.class);
                filter.injectDependencies((Cache)RemoteQueryEngine.this.cache);
                filter.getObjectFilter();
                return filter;
            }
        });
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return this.isCompatMode ? super.getIndexedFieldProvider(parsingResult) : new ProtobufIndexedFieldProvider((Descriptor)parsingResult.getTargetEntityMetadata());
    }

    protected LuceneProcessingChain makeProcessingChain() {
        LuceneProcessingChain processingChain;
        if (this.isCompatMode) {
            final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return RemoteQueryEngine.this.serCtx.canMarshall(entityName) ? RemoteQueryEngine.this.serCtx.getMarshaller(entityName).getJavaClass() : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){
                private final ClassBasedLucenePropertyHelper propertyHelper;
                {
                    this.propertyHelper = new ClassBasedLucenePropertyHelper(RemoteQueryEngine.this.searchFactory, entityNamesResolver);
                }

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    return this.propertyHelper.getFieldBridge(type, Arrays.asList(propertyPath.split("[.]")));
                }
            };
            processingChain = new LuceneProcessingChain.Builder(this.searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities(fieldBridgeProvider);
        } else {
            EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

                public Class<?> getClassFromName(String entityName) {
                    return RemoteQueryEngine.this.serCtx.canMarshall(entityName) ? ProtobufValueWrapper.class : null;
                }
            };
            FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){

                public FieldBridge getFieldBridge(String type, String propertyPath) {
                    FieldDescriptor fd = RemoteQueryEngine.this.getFieldDescriptor(RemoteQueryEngine.this.serCtx, type, propertyPath);
                    switch (fd.getType()) {
                        case DOUBLE: {
                            return NumericFieldBridge.DOUBLE_FIELD_BRIDGE;
                        }
                        case FLOAT: {
                            return NumericFieldBridge.FLOAT_FIELD_BRIDGE;
                        }
                        case INT64: 
                        case UINT64: 
                        case FIXED64: 
                        case SFIXED64: 
                        case SINT64: {
                            return NumericFieldBridge.LONG_FIELD_BRIDGE;
                        }
                        case INT32: 
                        case FIXED32: 
                        case UINT32: 
                        case SFIXED32: 
                        case SINT32: 
                        case BOOL: 
                        case ENUM: {
                            return NumericFieldBridge.INT_FIELD_BRIDGE;
                        }
                        case STRING: 
                        case BYTES: 
                        case GROUP: 
                        case MESSAGE: {
                            return new NullEncodingTwoWayFieldBridge((TwoWayFieldBridge)new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE), "_null_");
                        }
                    }
                    return null;
                }
            };
            processingChain = new LuceneProcessingChain.Builder(this.searchFactory, entityNamesResolver).buildProcessingChainForDynamicEntities(fieldBridgeProvider);
        }
        return processingChain;
    }

    private FieldDescriptor getFieldDescriptor(SerializationContext serCtx, String type, String attributePath) {
        Descriptor messageDescriptor = serCtx.getMessageDescriptor(type);
        FieldDescriptor fd = null;
        String[] split = attributePath.split("[.]");
        for (int i = 0; i < split.length; ++i) {
            String name = split[i];
            fd = messageDescriptor.findFieldByName(name);
            if (fd == null) {
                throw log.unknownField(name, messageDescriptor.getFullName());
            }
            IndexingMetadata indexingMetadata = (IndexingMetadata)messageDescriptor.getProcessedAnnotation("Indexed");
            if (indexingMetadata != null && !indexingMetadata.isFieldIndexed(fd.getNumber())) {
                throw log.fieldIsNotIndexed(name, messageDescriptor.getFullName());
            }
            if (i >= split.length - 1) continue;
            messageDescriptor = fd.getMessageType();
        }
        return fd;
    }
}

