/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.spi.service;

import javax.management.MBeanServer;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;

public class ChannelConnectorBuilder
implements Builder<Channel>,
Service<Channel> {
    private static final Logger LOGGER = Logger.getLogger(ChannelConnectorBuilder.class);
    private final String name;
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<MBeanServer> server = new InjectedValue();

    public ChannelConnectorBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ChannelServiceName.CONNECTOR.getServiceName(this.name);
    }

    public ServiceBuilder<Channel> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)this).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.name), Channel.class, this.channel).addDependency(ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, this.server).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Channel getValue() {
        return (Channel)this.channel.getValue();
    }

    public void start(StartContext context) throws StartException {
        Channel channel = this.getValue();
        if (channel instanceof JChannel) {
            try {
                JmxConfigurator.registerChannel((JChannel)((JChannel)channel), (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.name);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            channel.connect(this.name);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        Channel channel = this.getValue();
        channel.disconnect();
        if (channel instanceof JChannel) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)channel), (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.name);
            }
            catch (Exception e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

