/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.infinispan.server.commons.dmr.ModelNodes;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.ProtocolConfiguration;
import org.infinispan.server.jgroups.spi.ProtocolStackConfiguration;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.ProtocolMetricsHandler;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceRegistrationHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.Channel;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.Protocol;

public class ForkProtocolResourceRegistrationHandler
implements OperationStepHandler,
ProtocolMetricsHandler.ProtocolLocator {
    @Override
    public Protocol findProtocol(ServiceRegistry registry, PathAddress address) throws ClassNotFoundException, ModuleLoadException {
        ChannelFactory factory;
        FORK fork;
        Channel channel;
        String channelName = address.getElement(address.size() - 3).getValue();
        String forkName = address.getElement(address.size() - 2).getValue();
        String protocolName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = registry.getService(ChannelServiceName.CHANNEL.getServiceName(channelName));
        if (controller != null && (channel = (Channel)controller.getValue()) != null && (fork = (FORK)channel.getProtocolStack().findProtocol(FORK.class)) != null && (controller = registry.getService(ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(channelName))) != null && (factory = (ChannelFactory)controller.getValue()) != null) {
            ProtocolStackConfiguration configuration = factory.getProtocolStackConfiguration();
            for (ProtocolConfiguration protocol : configuration.getProtocols()) {
                if (!protocol.getName().equals(protocolName)) continue;
                Class<Protocol> protocolClass = configuration.getModuleLoader().loadModule(protocol.getModule()).getClassLoader().loadClass(protocol.getProtocolClassName()).asSubclass(Protocol.class);
                return fork.get(forkName).getProtocolStack().findProtocol(protocolClass);
            }
        }
        return null;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        String protocolName = context.getCurrentAddressValue();
        ModuleIdentifier module = ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.MODULE.resolveModelAttribute(context, operation));
        Class<? extends Protocol> protocolClass = ProtocolResourceRegistrationHandler.findProtocolClass(context, protocolName, module);
        final Map<String, ProtocolMetricsHandler.Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(protocolClass);
        OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                HashMap<String, ModelNode> result = new HashMap<String, ModelNode>();
                for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
                    ModelNode value = new ModelNode();
                    value.get("description").set(attribute.getDescription());
                    result.put(attribute.getName(), value);
                }
                return result;
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }
        };
        ManagementResourceRegistration protocolRegistration = registration.registerOverrideModel(protocolName, provider);
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler(this);
        for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
            String name = attribute.getName();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            protocolRegistration.registerMetric((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType()).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
    }
}

