/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class ProtocolMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final ProtocolLocator locator;

    public ProtocolMetricsHandler(ProtocolLocator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String protocolName = context.getCurrentAddressValue();
        String name = Operations.getAttributeName((ModelNode)operation);
        try {
            Protocol protocol = this.locator.findProtocol(context.getServiceRegistry(false), address);
            if (protocol != null) {
                Attribute attribute = ProtocolMetricsHandler.getAttribute(protocol.getClass(), name);
                if (attribute != null) {
                    FieldType type = FieldType.valueOf(attribute.getType());
                    try {
                        ModelNode result = new ModelNode();
                        Object value = attribute.read(protocol);
                        if (value != null) {
                            type.setValue(result, value);
                        }
                        context.getResult().set(result);
                    }
                    catch (Exception e) {
                        context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.privilegedAccessExceptionForAttribute(name));
                    }
                } else {
                    context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.unknownMetric(name));
                }
            } else {
                context.getFailureDescription().set(JGroupsLogger.ROOT_LOGGER.protocolNotFoundInStack(protocolName));
            }
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            context.getFailureDescription().set(e.getLocalizedMessage());
        }
        finally {
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    private static Attribute getAttribute(Class<? extends Protocol> targetClass, String name) {
        Map<String, Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(targetClass);
        return attributes.get(name);
    }

    static Map<String, Attribute> findProtocolAttributes(Class<? extends Protocol> protocolClass) {
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        Class<? extends Protocol> targetClass = protocolClass;
        while (Protocol.class.isAssignableFrom(targetClass)) {
            for (Method method : targetClass.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || !ProtocolMetricsHandler.isManagedAttribute(method)) continue;
                ProtocolMetricsHandler.putIfAbsent(attributes, new MethodAttribute(method));
            }
            for (AccessibleObject accessibleObject : targetClass.getDeclaredFields()) {
                if (!ProtocolMetricsHandler.isManagedAttribute(accessibleObject)) continue;
                ProtocolMetricsHandler.putIfAbsent(attributes, new FieldAttribute((Field)accessibleObject));
            }
            targetClass = targetClass.getSuperclass();
        }
        return attributes;
    }

    private static void putIfAbsent(Map<String, Attribute> attributes, Attribute attribute) {
        String name = attribute.getName();
        if (!attributes.containsKey(name)) {
            attributes.put(name, attribute);
        }
    }

    private static boolean isManagedAttribute(AccessibleObject object) {
        return object.isAnnotationPresent(ManagedAttribute.class) || object.isAnnotationPresent(Property.class) && object.getAnnotation(Property.class).exposeAsManagedAttribute();
    }

    static enum FieldType {
        BOOLEAN(ModelType.BOOLEAN, new Class[]{Boolean.TYPE, Boolean.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Boolean)value).booleanValue());
            }
        }
        ,
        INT(ModelType.INT, new Class[]{Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Number)value).intValue());
            }
        }
        ,
        LONG(ModelType.LONG, new Class[]{Long.TYPE, Long.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Number)value).longValue());
            }
        }
        ,
        DOUBLE(ModelType.DOUBLE, new Class[]{Double.TYPE, Double.class, Float.TYPE, Float.class}){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(((Number)value).doubleValue());
            }
        }
        ,
        STRING(ModelType.STRING, new Class[0]){

            @Override
            void setValue(ModelNode node, Object value) {
                node.set(value.toString());
            }
        };

        private static final Map<Class<?>, FieldType> TYPES;
        private final Class<?>[] types;
        private final ModelType modelType;

        private FieldType(ModelType modelType, Class<?> ... types) {
            this.modelType = modelType;
            this.types = types;
        }

        abstract void setValue(ModelNode var1, Object var2);

        public ModelType getModelType() {
            return this.modelType;
        }

        public static FieldType valueOf(Class<?> typeClass) {
            FieldType type = TYPES.get(typeClass);
            return type != null ? type : STRING;
        }

        static {
            TYPES = new HashMap();
            for (FieldType type : FieldType.values()) {
                for (Class<?> classType : type.types) {
                    TYPES.put(classType, type);
                }
            }
        }
    }

    static class MethodAttribute
    extends AbstractAttribute<Method> {
        MethodAttribute(Method method) {
            super(method);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name != null ? name : Util.methodNameToAttributeName((String)((Method)this.accessible).getName());
        }

        @Override
        public Class<?> getType() {
            return ((Method)this.accessible).getReturnType();
        }

        @Override
        Object get(Object object) throws IllegalAccessException, InvocationTargetException {
            return ((Method)this.accessible).invoke(object, new Object[0]);
        }
    }

    static class FieldAttribute
    extends AbstractAttribute<Field> {
        FieldAttribute(Field field) {
            super(field);
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name != null ? name : ((Field)this.accessible).getName();
        }

        @Override
        public Class<?> getType() {
            return ((Field)this.accessible).getType();
        }

        @Override
        Object get(Object object) throws IllegalAccessException {
            return ((Field)this.accessible).get(object);
        }
    }

    static abstract class AbstractAttribute<A extends AccessibleObject>
    implements Attribute {
        final A accessible;

        AbstractAttribute(A accessible) {
            this.accessible = accessible;
        }

        @Override
        public String getName() {
            String name;
            if (((AccessibleObject)this.accessible).isAnnotationPresent(ManagedAttribute.class) && !(name = ((AccessibleObject)this.accessible).getAnnotation(ManagedAttribute.class).name()).isEmpty()) {
                return name;
            }
            if (((AccessibleObject)this.accessible).isAnnotationPresent(Property.class) && !(name = ((AccessibleObject)this.accessible).getAnnotation(Property.class).name()).isEmpty()) {
                return name;
            }
            return null;
        }

        @Override
        public String getDescription() {
            if (((AccessibleObject)this.accessible).isAnnotationPresent(ManagedAttribute.class)) {
                return ((AccessibleObject)this.accessible).getAnnotation(ManagedAttribute.class).description();
            }
            if (((AccessibleObject)this.accessible).isAnnotationPresent(Property.class)) {
                return ((AccessibleObject)this.accessible).getAnnotation(Property.class).description();
            }
            return this.accessible.toString();
        }

        @Override
        public Object read(final Object object) throws Exception {
            PrivilegedExceptionAction<Object> action = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    boolean accessible = ((AccessibleObject)accessible).isAccessible();
                    if (!accessible) {
                        ((AccessibleObject)accessible).setAccessible(true);
                    }
                    try {
                        Object object2 = this.get(object);
                        return object2;
                    }
                    finally {
                        if (!accessible) {
                            ((AccessibleObject)accessible).setAccessible(false);
                        }
                    }
                }
            };
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }

        abstract Object get(Object var1) throws Exception;
    }

    static interface Attribute {
        public String getName();

        public String getDescription();

        public Class<?> getType();

        public Object read(Object var1) throws Exception;
    }

    static interface ProtocolLocator {
        public Protocol findProtocol(ServiceRegistry var1, PathAddress var2) throws ClassNotFoundException, ModuleLoadException;
    }
}

