/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.outbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.wst.UnknownTransactionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.outbound.OutboundBridgeManager;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;
import org.jboss.jbossts.xts.bridge.at.BridgeWrapper;

public class BridgeXAResource
implements XAResource,
Serializable {
    private static final List<BridgeXAResource> xaResourcesAwaitingRecovery = Collections.synchronizedList(new LinkedList());
    private volatile transient BridgeWrapper bridgeWrapper;
    private volatile Uid externalTxId;
    private volatile String bridgeWrapperId;
    private volatile transient boolean isAwaitingRecovery = false;

    public BridgeXAResource(Uid externalTxId, BridgeWrapper bridgeWrapper) {
        txbridgeLogger.logger.trace((Object)("BridgeXARresource.<ctor>(TxId=" + externalTxId + ", BridgeWrapper=" + bridgeWrapper + ")"));
        this.externalTxId = externalTxId;
        this.bridgeWrapper = bridgeWrapper;
        this.bridgeWrapperId = bridgeWrapper.getIdentifier();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.writeObject() for tx id=" + this.externalTxId));
        out.writeObject(this.externalTxId);
        out.writeObject(this.bridgeWrapperId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        txbridgeLogger.logger.trace((Object)"BridgeXAResource.readObject()");
        this.externalTxId = (Uid)in.readObject();
        this.bridgeWrapperId = (String)in.readObject();
        this.isAwaitingRecovery = true;
        List<BridgeXAResource> list = xaResourcesAwaitingRecovery;
        synchronized (list) {
            xaResourcesAwaitingRecovery.add(this);
        }
        try {
            this.bridgeWrapper = BridgeWrapper.recover((String)this.bridgeWrapperId);
        }
        catch (UnknownTransactionException unknownTransactionException) {
            txbridgeLogger.i18NLogger.error_obxar_unabletorecover(this.bridgeWrapperId, unknownTransactionException);
            throw new IOException(unknownTransactionException);
        }
    }

    private void ensureRecoveryIsDoneIfNeeded(int exceptionCode) throws XAException {
        if (this.bridgeWrapper == null) {
            try {
                this.bridgeWrapper = BridgeWrapper.recover((String)this.bridgeWrapperId);
                if (this.bridgeWrapper == null) {
                    throw new XAException(exceptionCode);
                }
            }
            catch (UnknownTransactionException unknownTransactionException) {
                txbridgeLogger.i18NLogger.error_obxar_unabletorecover(this.bridgeWrapperId, unknownTransactionException);
                XAException xaException = new XAException(-4);
                xaException.initCause(unknownTransactionException);
                throw xaException;
            }
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.prepare(Xid=" + xid + ")"));
        int twoPhaseOutcome = this.bridgeWrapper.prepare();
        txbridgeLogger.logger.trace((Object)("prepare TwoPhaseOutcome is " + twoPhaseOutcome + "/" + TwoPhaseOutcome.stringForm((int)twoPhaseOutcome)));
        switch (twoPhaseOutcome) {
            case 0: {
                txbridgeLogger.logger.trace((Object)"prepare returning XAResource.XA_OK");
                return 0;
            }
            case 2: {
                this.cleanupRefs();
                txbridgeLogger.logger.trace((Object)"prepare returning XAResource.XA_RDONLY");
                return 3;
            }
        }
        txbridgeLogger.logger.trace((Object)("prepare TwoPhaseOutcome is " + twoPhaseOutcome + "/" + TwoPhaseOutcome.stringForm((int)twoPhaseOutcome) + ", throwing XAException..."));
        XAException xaException = new XAException("unexpected oucome: " + TwoPhaseOutcome.stringForm((int)twoPhaseOutcome));
        xaException.errorCode = 100;
        throw xaException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupRecoveredXAResources() {
        txbridgeLogger.logger.trace((Object)"BridgeXAResource.cleanupRecoveredXAResources()");
        List<BridgeXAResource> list = xaResourcesAwaitingRecovery;
        synchronized (list) {
            Iterator<BridgeXAResource> iter = xaResourcesAwaitingRecovery.iterator();
            while (iter.hasNext()) {
                BridgeXAResource xaResource = iter.next();
                if (xaResource.isAwaitingRecovery()) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAwaitingRecovery(String bridgeWrapperId) {
        List<BridgeXAResource> list = xaResourcesAwaitingRecovery;
        synchronized (list) {
            for (BridgeXAResource bridgeXAResource : xaResourcesAwaitingRecovery) {
                if (!bridgeXAResource.bridgeWrapperId.equals(bridgeWrapperId)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.rollback(Xid=" + xid + ")"));
        this.ensureRecoveryIsDoneIfNeeded(-7);
        try {
            this.bridgeWrapper.rollback();
        }
        finally {
            this.cleanupRefs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.commit(Xid=" + xid + ", onePhase=" + onePhase + ")"));
        this.ensureRecoveryIsDoneIfNeeded(4);
        try {
            if (onePhase && this.prepare(xid) == 3) {
                return;
            }
            this.bridgeWrapper.commit();
        }
        finally {
            this.cleanupRefs();
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.start(Xid=" + xid + ", flags=" + flags + ")"));
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.end(Xid=" + xid + ", flags=" + flags + ")"));
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.isSameRM(XAResource=" + xaResource + ")"));
        return false;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        txbridgeLogger.logger.trace((Object)("forget(Xid=" + xid + ")"));
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.recover(flag=" + flag + ")"));
        return new Xid[0];
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        txbridgeLogger.logger.trace((Object)("BridgeXAResource.setTransactionTimeout(seconds=" + seconds + ")"));
        return false;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        txbridgeLogger.logger.trace((Object)"BridgeXAResource.getTransactionTimeout()");
        return 0;
    }

    public boolean isAwaitingRecovery() {
        return this.isAwaitingRecovery;
    }

    private void cleanupRefs() {
        txbridgeLogger.logger.trace((Object)"BridgeXAResource.cleanupRefs()");
        OutboundBridgeManager.removeMapping(this.externalTxId);
        this.isAwaitingRecovery = false;
    }
}

