/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.List;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.interceptors.InterceptorClassDescription;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class PassivationAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName POST_ACTIVATE = DotName.createSimple((String)PostActivate.class.getName());
    private static final DotName PRE_PASSIVATE = DotName.createSimple((String)PrePassivate.class.getName());
    private static DotName[] PASSIVATION_ANNOTATIONS = new DotName[]{POST_ACTIVATE, PRE_PASSIVATE};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName annotationName : PASSIVATION_ANNOTATIONS) {
            List lifecycles = index.getAnnotations(annotationName);
            for (AnnotationInstance annotation : lifecycles) {
                this.processPassivation(eeModuleDescription, annotation.target(), annotationName, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processPassivation(EEModuleDescription eeModuleDescription, AnnotationTarget target, DotName annotationType, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        if (!(target instanceof MethodInfo)) {
            throw EeLogger.ROOT_LOGGER.methodOnlyAnnotation(annotationType);
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = eeModuleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
        Type[] args = methodInfo.args();
        if (args.length > 1) {
            EeLogger.ROOT_LOGGER.warn((Object)EeLogger.ROOT_LOGGER.invalidNumberOfArguments(methodInfo.name(), annotationType, classInfo.name()));
            return;
        }
        if (args.length == 1 && !args[0].name().toString().equals(InvocationContext.class.getName())) {
            EeLogger.ROOT_LOGGER.warn((Object)EeLogger.ROOT_LOGGER.invalidSignature(methodInfo.name(), annotationType, classInfo.name(), "void methodName(InvocationContext ctx)"));
            return;
        }
        MethodIdentifier methodIdentifier = args.length == 0 ? MethodIdentifier.getIdentifier(Void.TYPE, (String)methodInfo.name(), (Class[])new Class[0]) : MethodIdentifier.getIdentifier(Void.TYPE, (String)methodInfo.name(), (Class[])new Class[]{InvocationContext.class});
        InterceptorClassDescription.Builder builder = InterceptorClassDescription.builder((InterceptorClassDescription)classDescription.getInterceptorClassDescription());
        if (annotationType == POST_ACTIVATE) {
            builder.setPostActivate(methodIdentifier);
        } else {
            builder.setPrePassivate(methodIdentifier);
        }
        classDescription.setInterceptorClassDescription(builder.build());
    }
}

