/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.resources.ServerGroupResourceDefinition;
import org.jboss.as.host.controller.mgmt.DomainControllerRuntimeIgnoreTransformationRegistry;
import org.jboss.dmr.ModelNode;

public class ServerGroupSocketBindingGroupWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    private final boolean master;
    private final DomainControllerRuntimeIgnoreTransformationRegistry registry;

    public ServerGroupSocketBindingGroupWriteAttributeHandler(boolean master, DomainControllerRuntimeIgnoreTransformationRegistry registry) {
        super(new AttributeDefinition[]{ServerGroupResourceDefinition.SOCKET_BINDING_GROUP});
        this.master = master;
        this.registry = registry;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, Resource resource) throws OperationFailedException {
        if (newValue.equals(currentValue)) {
            ServerOperationResolver.addToDontPropagateToServersAttachment(context, operation);
        }
        boolean reloadRequired = false;
        String socketBindingGroup = ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.resolveModelAttribute(context, resource.getModel()).asString();
        try {
            context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)ServerGroupResourceDefinition.SOCKET_BINDING_GROUP.getName(), (String)socketBindingGroup)}));
        }
        catch (Exception e) {
            if (this.master) {
                throw DomainControllerLogger.ROOT_LOGGER.noSocketBindingGroupCalled(socketBindingGroup);
            }
            context.reloadRequired();
            reloadRequired = true;
        }
        if (this.registry != null) {
            this.registry.changeServerGroupSocketBindingGroup(context, PathAddress.pathAddress((ModelNode)operation.require("address")), newValue.asString());
        }
        final boolean revertReloadRequiredOnRollback = reloadRequired;
        if (reloadRequired) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            if (resultAction == OperationContext.ResultAction.ROLLBACK && revertReloadRequiredOnRollback) {
                                context.revertReloadRequired();
                            }
                        }
                    });
                }
            }, OperationContext.Stage.MODEL);
        }
    }
}

