/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.web.infinispan.session.MockImmutableSession;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.Time;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class ScheduleSchedulerCommand
implements Command<Void, Scheduler> {
    private static final long serialVersionUID = -2606847692331278614L;
    private final transient ImmutableSession session;
    private final String id;
    private final long maxInactiveInterval;
    private final long lastAccessedTime;

    public ScheduleSchedulerCommand(ImmutableSession session) {
        this.session = session;
        this.id = session.getId();
        this.maxInactiveInterval = session.getMetaData().getMaxInactiveInterval(TimeUnit.MILLISECONDS);
        this.lastAccessedTime = session.getMetaData().getLastAccessedTime().getTime();
    }

    public Void execute(Scheduler scheduler) {
        ImmutableSession session = this.session != null ? this.session : new MockImmutableSession(this.id, (ImmutableSessionMetaData)new SimpleSessionMetaData(null, new Date(this.lastAccessedTime), new Time(this.maxInactiveInterval, TimeUnit.MILLISECONDS)));
        scheduler.schedule(session);
        return null;
    }
}

