/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import java.util.concurrent.TimeUnit;

public class ResponseTimeAttribute
implements ExchangeAttribute {
    public static final String RESPONSE_TIME_MILLIS_SHORT = "%D";
    public static final String RESPONSE_TIME_SECONDS_SHORT = "%T";
    public static final String RESPONSE_TIME_MILLIS = "%{RESPONSE_TIME}";
    public static final String RESPONSE_TIME_NANOS = "%{RESPONSE_TIME_NANOS}";
    private final TimeUnit timeUnit;

    public ResponseTimeAttribute(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        long requestStartTime = exchange.getRequestStartTime();
        if (requestStartTime == -1L) {
            return null;
        }
        return String.valueOf(this.timeUnit.convert(System.nanoTime() - requestStartTime, TimeUnit.NANOSECONDS));
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Response Time", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response Time";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_MILLIS) || token.equals(ResponseTimeAttribute.RESPONSE_TIME_MILLIS_SHORT)) {
                return new ResponseTimeAttribute(TimeUnit.MILLISECONDS);
            }
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_SECONDS_SHORT)) {
                return new ResponseTimeAttribute(TimeUnit.SECONDS);
            }
            if (token.equals(ResponseTimeAttribute.RESPONSE_TIME_NANOS)) {
                return new ResponseTimeAttribute(TimeUnit.NANOSECONDS);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

