/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DelegatingStreamSourceChannel<T extends DelegatingStreamSourceChannel>
implements StreamSourceChannel {
    protected final ChannelListener.SimpleSetter<T> readSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<T> closeSetter = new ChannelListener.SimpleSetter();
    protected final StreamSourceChannel delegate;

    public DelegatingStreamSourceChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
        delegate.getReadSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.readSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener((Channel)((Object)this), this.closeSetter));
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.delegate.transferTo(position, count, target);
    }

    public void awaitReadable() throws IOException {
        this.delegate.awaitReadable();
    }

    public void suspendReads() {
        this.delegate.suspendReads();
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.delegate.transferTo(count, throughBuffer, target);
    }

    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    public boolean isReadResumed() {
        return this.delegate.isReadResumed();
    }

    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return (T)this.delegate.setOption(option, value);
    }

    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    public void shutdownReads() throws IOException {
        this.delegate.shutdownReads();
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
        return this.readSetter;
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        return this.delegate.read(dsts);
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.delegate.read(dsts, offset, length);
    }

    public void wakeupReads() {
        this.delegate.wakeupReads();
    }

    public XnioExecutor getReadThread() {
        return this.delegate.getReadThread();
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitReadable(time, timeUnit);
    }

    public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
        return this.closeSetter;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public <T> T getOption(Option<T> option) throws IOException {
        return (T)this.delegate.getOption(option);
    }

    public void resumeReads() {
        this.delegate.resumeReads();
    }

    public int read(ByteBuffer dst) throws IOException {
        return this.delegate.read(dst);
    }

    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }
}

