/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;
import org.jboss.logging.Logger;

public final class ReflectionPropertyHelper
extends ObjectPropertyHelper<Class<?>> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ReflectionPropertyHelper.class.getName());
    private static final Set<Class<?>> primitives = new HashSet();

    public ReflectionPropertyHelper(EntityNamesResolver entityNamesResolver) {
        super(entityNamesResolver);
    }

    @Override
    public Class<?> getEntityMetadata(String targetTypeName) {
        return this.entityNamesResolver.getClassFromName(targetTypeName);
    }

    @Override
    public Class<?> getPrimitivePropertyType(String entityType, List<String> propertyPath) {
        Class type = this.entityNamesResolver.getClassFromName(entityType);
        if (type == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        Class<?> propType = this.getPropertyAccessor(type, propertyPath).getPropertyType();
        if (propType.isEnum() || primitives.contains(propType)) {
            return propType;
        }
        return null;
    }

    @Override
    public boolean hasProperty(String entityType, List<String> propertyPath) {
        return this.hasProperty(entityType, propertyPath.toArray(new String[propertyPath.size()]));
    }

    @Override
    public boolean hasEmbeddedProperty(String entityType, List<String> propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, propertyPath).getPropertyType();
            return propType != null && !propType.isEnum() && !primitives.contains(propType);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isRepeatedProperty(String entityType, List<String> propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        ReflectionHelper.PropertyAccessor a = ReflectionHelper.getAccessor(entity, propertyPath.get(0));
        if (a.isMultiple()) {
            return true;
        }
        for (int i = 1; i < propertyPath.size(); ++i) {
            if (!(a = a.getAccessor(propertyPath.get(i))).isMultiple()) continue;
            return true;
        }
        return false;
    }

    private boolean hasProperty(String entityType, String ... propertyPath) {
        Class entity = this.entityNamesResolver.getClassFromName(entityType);
        if (entity == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        try {
            Class<?> propType = this.getPropertyAccessor(entity, Arrays.asList(propertyPath)).getPropertyType();
            return propType != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ReflectionHelper.PropertyAccessor getPropertyAccessor(Class<?> entityClass, List<String> propertyPath) {
        ReflectionHelper.PropertyAccessor accessor = ReflectionHelper.getAccessor(entityClass, propertyPath.get(0));
        for (int i = 1; i < propertyPath.size(); ++i) {
            accessor = accessor.getAccessor(propertyPath.get(i));
        }
        return accessor;
    }

    static {
        primitives.add(Date.class);
        primitives.add(String.class);
        primitives.add(Character.class);
        primitives.add(Character.TYPE);
        primitives.add(Double.class);
        primitives.add(Double.TYPE);
        primitives.add(Float.class);
        primitives.add(Float.TYPE);
        primitives.add(Long.class);
        primitives.add(Long.TYPE);
        primitives.add(Integer.class);
        primitives.add(Integer.TYPE);
        primitives.add(Short.class);
        primitives.add(Short.TYPE);
        primitives.add(Byte.class);
        primitives.add(Byte.TYPE);
        primitives.add(Boolean.class);
        primitives.add(Boolean.TYPE);
    }
}

