/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.w3c.dom.Document;

public class UsernameTokenAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        String username = reqData.getUsername();
        String password = null;
        if (reqData.getPwType() != null) {
            CallbackHandler callbackHandler = handler.getPasswordCallbackHandler(reqData);
            WSPasswordCallback passwordCallback = handler.getPasswordCB(reqData.getUsername(), 1, callbackHandler, reqData);
            username = passwordCallback.getIdentifier();
            password = passwordCallback.getPassword();
        }
        WSSecUsernameToken builder = new WSSecUsernameToken(reqData.getWssConfig());
        builder.setPasswordType(reqData.getPwType());
        builder.setPasswordsAreEncoded(reqData.getWssConfig().getPasswordsAreEncoded());
        builder.setUserInfo(username, password);
        if (reqData.isAddUsernameTokenNonce()) {
            builder.addNonce();
        }
        if (reqData.isAddUsernameTokenCreated()) {
            builder.addCreated();
        }
        builder.build(doc, reqData.getSecHeader());
    }
}

