/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public final class ServiceLoaderProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        HashMap<String, List<String>> foundServices = new HashMap<String, List<String>>();
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot != null) {
            this.processRoot(deploymentRoot, foundServices);
        }
        List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
            this.processRoot(resourceRoot, foundServices);
        }
        deploymentUnit.putAttachment(Attachments.SERVICES, new ServicesAttachment(foundServices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRoot(ResourceRoot resourceRoot, Map<String, List<String>> foundServices) throws DeploymentUnitProcessingException {
        VirtualFile virtualFile = resourceRoot.getRoot();
        VirtualFile child = virtualFile.getChild("META-INF/services");
        for (VirtualFile serviceType : child.getChildren()) {
            String name = serviceType.getName();
            try {
                List<String> list = foundServices.get(name);
                if (list == null) {
                    list = new ArrayList<String>();
                    foundServices.put(name, list);
                }
                InputStream stream = serviceType.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    while ((line = reader.readLine()) != null) {
                        int commentIdx = line.indexOf(35);
                        String className = commentIdx == -1 ? line.trim() : line.substring(0, commentIdx).trim();
                        if (className.length() == 0) continue;
                        list.add(className);
                    }
                }
                finally {
                    VFSUtils.safeClose((Closeable)stream);
                }
            }
            catch (IOException e) {
                throw ServerLogger.ROOT_LOGGER.failedToReadVirtualFile(child, e);
            }
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
        context.removeAttachment(Attachments.SERVICES);
    }
}

