/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.hql.lucene.internal.builder.ClassBasedLucenePropertyHelper;
import org.hibernate.hql.lucene.spi.FieldBridgeProvider;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.BaseMatcher;
import org.infinispan.objectfilter.impl.ReflectionMatcher;
import org.infinispan.objectfilter.impl.RowMatcher;
import org.infinispan.objectfilter.impl.aggregation.AvgAccumulator;
import org.infinispan.objectfilter.impl.aggregation.CountAccumulator;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MaxAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MinAccumulator;
import org.infinispan.objectfilter.impl.aggregation.SumAccumulator;
import org.infinispan.objectfilter.impl.hql.FilterParsingResult;
import org.infinispan.objectfilter.impl.hql.ObjectPropertyHelper;
import org.infinispan.objectfilter.impl.hql.RowPropertyHelper;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleShannonExpansion;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanFilterNormalizer;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.JPATreePrinter;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.LuceneQuery;
import org.infinispan.query.dsl.embedded.impl.AggregatingQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedLuceneQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQuery;
import org.infinispan.query.dsl.embedded.impl.EmptyResultQuery;
import org.infinispan.query.dsl.embedded.impl.HibernateSearchIndexedFieldProvider;
import org.infinispan.query.dsl.embedded.impl.HybridQuery;
import org.infinispan.query.dsl.embedded.impl.JPAFilterAndConverter;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.dsl.embedded.impl.SecurityActions;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.util.KeyValuePair;

public class QueryEngine {
    protected final AdvancedCache<?, ?> cache;
    protected final QueryCache queryCache;
    protected final SearchManager searchManager;
    protected final SearchIntegrator searchFactory;
    protected final QueryParser queryParser = new QueryParser();
    protected final BooleanFilterNormalizer booleanFilterNormalizer = new BooleanFilterNormalizer();

    public QueryEngine(AdvancedCache<?, ?> cache, SearchManager searchManager) {
        this.cache = cache;
        this.queryCache = ComponentRegistryUtils.getQueryCache(cache);
        this.searchManager = searchManager;
        this.searchFactory = searchManager != null ? searchManager.unwrap(SearchIntegrator.class) : null;
    }

    public Query buildQuery(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults) {
        FilterParsingResult<?> parsingResult = this.parse(jpqlString);
        if (parsingResult.hasGroupingOrAggregations()) {
            return this.buildQueryWithAggregations(queryFactory, jpqlString, startOffset, maxResults, parsingResult);
        }
        return this.buildQueryNoAggregations(queryFactory, jpqlString, startOffset, maxResults, parsingResult);
    }

    private Query buildQueryWithAggregations(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        RowPropertyHelper.ColumnMetadata c;
        if (parsingResult.getProjectedPaths().isEmpty()) {
            throw new ParsingException("Queries containing grouping and aggregation functions must use projections.");
        }
        LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns = new LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata>();
        ObjectPropertyHelper propertyHelper = this.getFirstPhaseMatcher().getPropertyHelper();
        LinkedHashSet<Integer> groupFieldPositions = new LinkedHashSet<Integer>();
        for (PropertyPath p : parsingResult.getGroupBy()) {
            if (columns.containsKey(p)) continue;
            int idx = columns.size();
            Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
            groupFieldPositions.add(idx);
        }
        for (PropertyPath p : parsingResult.getProjectedPaths()) {
            RowPropertyHelper.ColumnMetadata c2 = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p.getAggregationType() != null || c2 != null && groupFieldPositions.contains(c2.getColumnIndex()))) {
                throw new ParsingException("The expression '" + p + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
            }
            if (c2 != null) continue;
            int idx = columns.size();
            Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        for (SortField sortField : parsingResult.getSortFields()) {
            PropertyPath p = sortField.getPath();
            RowPropertyHelper.ColumnMetadata c3 = (RowPropertyHelper.ColumnMetadata)columns.get(p);
            if (!(p.getAggregationType() != null || c3 != null && groupFieldPositions.contains(c3.getColumnIndex()))) {
                throw new ParsingException("The expression '" + p + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
            }
            if (c3 != null) continue;
            int idx = columns.size();
            Class propertyType = propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), p.getPath());
            columns.put(p, new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyType));
        }
        String havingClause = null;
        if (parsingResult.getHavingClause() != null) {
            BooleanExpr normalizedHavingClause = this.booleanFilterNormalizer.normalize(parsingResult.getHavingClause());
            if (normalizedHavingClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, startOffset, maxResults);
            }
            if (normalizedHavingClause != ConstantBooleanExpr.TRUE) {
                havingClause = JPATreePrinter.printTree((BooleanExpr)this.swapVariables(normalizedHavingClause, parsingResult, columns));
            }
        }
        StringBuilder firstPhaseQuery = new StringBuilder();
        firstPhaseQuery.append("SELECT ");
        boolean isFirst = true;
        for (PropertyPath c4 : columns.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                firstPhaseQuery.append(", ");
            }
            firstPhaseQuery.append("_gen0.").append(c4.asStringPath());
        }
        firstPhaseQuery.append(" FROM ").append(parsingResult.getTargetEntityName()).append(" _gen0");
        if (parsingResult.getWhereClause() != null) {
            BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
            if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
                return new EmptyResultQuery(queryFactory, this.cache, jpqlString, startOffset, maxResults);
            }
            if (normalizedWhereClause != ConstantBooleanExpr.TRUE) {
                firstPhaseQuery.append(' ').append(JPATreePrinter.printTree((BooleanExpr)normalizedWhereClause));
            }
        }
        StringBuilder secondPhaseQuery = new StringBuilder();
        secondPhaseQuery.append("SELECT ");
        boolean isFirst2 = true;
        for (PropertyPath p : parsingResult.getProjectedPaths()) {
            if (isFirst2) {
                isFirst2 = false;
            } else {
                secondPhaseQuery.append(", ");
            }
            c = columns.get(p);
            secondPhaseQuery.append(c.getColumnName());
        }
        secondPhaseQuery.append(" FROM Row ");
        if (havingClause != null) {
            secondPhaseQuery.append(' ').append(havingClause);
        }
        if (!parsingResult.getSortFields().isEmpty()) {
            secondPhaseQuery.append(" ORDER BY ");
            isFirst2 = true;
            for (SortField sortField : parsingResult.getSortFields()) {
                if (isFirst2) {
                    isFirst2 = false;
                } else {
                    secondPhaseQuery.append(", ");
                }
                c = columns.get(sortField.getPath());
                secondPhaseQuery.append(c.getColumnName()).append(' ').append(sortField.isAscending() ? "ASC" : "DESC");
            }
        }
        LinkedList<Object> accumulators = new LinkedList<Object>();
        RowPropertyHelper.ColumnMetadata[] _columns = new RowPropertyHelper.ColumnMetadata[columns.size()];
        block13: for (PropertyPath p : columns.keySet()) {
            RowPropertyHelper.ColumnMetadata c5 = columns.get(p);
            _columns[c5.getColumnIndex()] = c5;
            if (p.getAggregationType() != null) {
                switch (p.getAggregationType()) {
                    case SUM: {
                        accumulators.add(new SumAccumulator(c5.getColumnIndex(), c5.getPropertyType()));
                        continue block13;
                    }
                    case AVG: {
                        accumulators.add(new AvgAccumulator(c5.getColumnIndex(), c5.getPropertyType()));
                        continue block13;
                    }
                    case MIN: {
                        accumulators.add(new MinAccumulator(c5.getColumnIndex(), c5.getPropertyType()));
                        continue block13;
                    }
                    case MAX: {
                        accumulators.add(new MaxAccumulator(c5.getColumnIndex(), c5.getPropertyType()));
                        continue block13;
                    }
                    case COUNT: {
                        accumulators.add(new CountAccumulator(c5.getColumnIndex()));
                        continue block13;
                    }
                }
                throw new IllegalStateException("Aggregation " + p.getAggregationType().name() + " is not supported");
            }
            groupFieldPositions.add(c5.getColumnIndex());
        }
        int[] _groupFieldPositions = new int[groupFieldPositions.size()];
        int i = 0;
        for (Integer pos : groupFieldPositions) {
            _groupFieldPositions[i++] = pos;
        }
        FieldAccumulator[] _accumulators = accumulators.toArray(new FieldAccumulator[accumulators.size()]);
        String firstPhaseQueryStr = firstPhaseQuery.toString();
        Query baseQuery = this.buildQueryNoAggregations(queryFactory, firstPhaseQueryStr, -1L, -1, this.parse(firstPhaseQueryStr));
        String secondPhaseQueryStr = secondPhaseQuery.toString();
        return new AggregatingQuery(queryFactory, this.cache, secondPhaseQueryStr, _groupFieldPositions, _accumulators, this.getObjectFilter(secondPhaseQueryStr, (BaseMatcher)new RowMatcher(_columns)), startOffset, maxResults, baseQuery);
    }

    private BooleanExpr swapVariables(BooleanExpr expr, final FilterParsingResult<?> parsingResult, final LinkedHashMap<PropertyPath, RowPropertyHelper.ColumnMetadata> columns) {
        final ObjectPropertyHelper propertyHelper = this.getFirstPhaseMatcher().getPropertyHelper();
        class PropertyReplacer
        implements Visitor {
            PropertyReplacer() {
            }

            public BooleanExpr visit(NotExpr notExpr) {
                return new NotExpr((BooleanExpr)notExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(OrExpr orExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : orExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new OrExpr(visitedChildren);
            }

            public BooleanExpr visit(AndExpr andExpr) {
                ArrayList<Object> visitedChildren = new ArrayList<Object>();
                for (BooleanExpr c : andExpr.getChildren()) {
                    visitedChildren.add(c.acceptVisitor((Visitor)this));
                }
                return new AndExpr(visitedChildren);
            }

            public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
                return constantBooleanExpr;
            }

            public BooleanExpr visit(IsNullExpr isNullExpr) {
                return new IsNullExpr((ValueExpr)isNullExpr.getChild().acceptVisitor((Visitor)this));
            }

            public BooleanExpr visit(ComparisonExpr comparisonExpr) {
                return new ComparisonExpr((ValueExpr)comparisonExpr.getLeftChild().acceptVisitor((Visitor)this), comparisonExpr.getRightChild(), comparisonExpr.getComparisonType());
            }

            public BooleanExpr visit(LikeExpr likeExpr) {
                return new LikeExpr((ValueExpr)likeExpr.getChild().acceptVisitor((Visitor)this), likeExpr.getPattern());
            }

            public ValueExpr visit(ConstantValueExpr constantValueExpr) {
                return constantValueExpr;
            }

            public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
                PropertyPath p = new PropertyPath(null, propertyValueExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    throw new ParsingException("The expression '" + propertyValueExpr.toJpaString() + "' must be part of an aggregate function or it should be included in the GROUP BY clause");
                }
                return new PropertyValueExpr(c.getColumnName(), propertyValueExpr.isRepeated());
            }

            public ValueExpr visit(AggregationExpr aggregationExpr) {
                PropertyPath p = new PropertyPath(aggregationExpr.getAggregationType(), aggregationExpr.getPropertyPath());
                RowPropertyHelper.ColumnMetadata c = (RowPropertyHelper.ColumnMetadata)columns.get(p);
                if (c == null) {
                    int idx = columns.size();
                    c = new RowPropertyHelper.ColumnMetadata(idx, "C" + idx, propertyHelper.getPrimitivePropertyType(parsingResult.getTargetEntityName(), aggregationExpr.getPropertyPath()));
                    columns.put(p, c);
                }
                return new PropertyValueExpr(c.getColumnName(), aggregationExpr.isRepeated());
            }
        }
        return (BooleanExpr)expr.acceptVisitor((Visitor)new PropertyReplacer());
    }

    private Query buildQueryNoAggregations(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults, FilterParsingResult<?> parsingResult) {
        if (parsingResult.hasGroupingOrAggregations()) {
            throw new IllegalArgumentException("The query must not use grouping or aggregation");
        }
        BooleanExpr normalizedWhereClause = this.booleanFilterNormalizer.normalize(parsingResult.getWhereClause());
        if (normalizedWhereClause == ConstantBooleanExpr.FALSE) {
            return new EmptyResultQuery(queryFactory, this.cache, jpqlString, startOffset, maxResults);
        }
        if (normalizedWhereClause == null || normalizedWhereClause == ConstantBooleanExpr.TRUE || this.searchManager == null) {
            return new EmbeddedQuery(queryFactory, this.cache, this.makeFilter(jpqlString), startOffset, maxResults);
        }
        BooleShannonExpansion bse = new BooleShannonExpansion(this.getIndexedFieldProvider(parsingResult));
        BooleanExpr expansion = bse.expand(normalizedWhereClause);
        if (expansion == normalizedWhereClause) {
            return this.buildLuceneQuery(queryFactory, jpqlString, startOffset, maxResults);
        }
        if (expansion == ConstantBooleanExpr.TRUE) {
            return new EmbeddedQuery(queryFactory, this.cache, this.makeFilter(jpqlString), startOffset, maxResults);
        }
        String expandedJpaOut = JPATreePrinter.printTree((String)parsingResult.getTargetEntityName(), (BooleanExpr)expansion, null);
        LuceneQuery expandedQuery = this.buildLuceneQuery(queryFactory, expandedJpaOut, -1L, -1);
        return new HybridQuery(queryFactory, this.cache, jpqlString, this.getObjectFilter(jpqlString, this.getSecondPhaseMatcher()), startOffset, maxResults, expandedQuery);
    }

    protected BaseMatcher getFirstPhaseMatcher() {
        return (BaseMatcher)SecurityActions.getCacheComponentRegistry(this.cache).getComponent(ReflectionMatcher.class);
    }

    protected BaseMatcher getSecondPhaseMatcher() {
        return this.getFirstPhaseMatcher();
    }

    private FilterParsingResult<?> parse(String jpqlString) {
        FilterParsingResult parsingResult;
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, FilterParsingResult.class);
            parsingResult = (FilterParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = this.getFirstPhaseMatcher().parse(jpqlString, null);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = this.getFirstPhaseMatcher().parse(jpqlString, null);
        }
        return parsingResult;
    }

    private ObjectFilter getObjectFilter(String jpqlString, BaseMatcher matcher) {
        ObjectFilter objectFilter;
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, matcher.getClass());
            objectFilter = (ObjectFilter)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (objectFilter == null) {
                objectFilter = matcher.getObjectFilter(jpqlString);
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, objectFilter);
            }
        } else {
            objectFilter = matcher.getObjectFilter(jpqlString);
        }
        return objectFilter;
    }

    protected BooleShannonExpansion.IndexedFieldProvider getIndexedFieldProvider(FilterParsingResult<?> parsingResult) {
        return new HibernateSearchIndexedFieldProvider(this.searchFactory, (Class)parsingResult.getTargetEntityMetadata());
    }

    protected JPAFilterAndConverter makeFilter(final String jpaQuery) {
        return SecurityActions.doPrivileged(new PrivilegedAction<JPAFilterAndConverter>(){

            @Override
            public JPAFilterAndConverter run() {
                JPAFilterAndConverter filter = new JPAFilterAndConverter(jpaQuery, ReflectionMatcher.class);
                filter.injectDependencies((Cache)QueryEngine.this.cache);
                filter.getObjectFilter();
                return filter;
            }
        });
    }

    public LuceneQuery buildLuceneQuery(QueryFactory queryFactory, String jpqlString, long startOffset, int maxResults) {
        if (this.searchManager == null) {
            throw new IllegalStateException("Cannot run Lucene queries on a cache that does not have indexing enabled");
        }
        LuceneQueryParsingResult parsingResult = this.transformJpaToLucene(jpqlString);
        org.apache.lucene.search.Query luceneQuery = this.makeTypeQuery(parsingResult.getQuery(), parsingResult.getTargetEntityName());
        CacheQuery cacheQuery = this.searchManager.getQuery(luceneQuery, parsingResult.getTargetEntity());
        if (parsingResult.getSort() != null) {
            cacheQuery = cacheQuery.sort(parsingResult.getSort());
        }
        String[] projection = null;
        if (parsingResult.getProjections() != null && !parsingResult.getProjections().isEmpty()) {
            int projSize = parsingResult.getProjections().size();
            projection = parsingResult.getProjections().toArray(new String[projSize]);
            cacheQuery = cacheQuery.projection(projection);
        }
        if (startOffset >= 0L) {
            cacheQuery = cacheQuery.firstResult((int)startOffset);
        }
        if (maxResults > 0) {
            cacheQuery = cacheQuery.maxResults(maxResults);
        }
        return new EmbeddedLuceneQuery(queryFactory, jpqlString, projection, cacheQuery);
    }

    protected org.apache.lucene.search.Query makeTypeQuery(org.apache.lucene.search.Query query, String targetEntityName) {
        return query;
    }

    private LuceneQueryParsingResult transformJpaToLucene(String jpqlString) {
        LuceneQueryParsingResult parsingResult;
        if (this.queryCache != null) {
            KeyValuePair queryCacheKey = new KeyValuePair((Object)jpqlString, LuceneQueryParsingResult.class);
            parsingResult = (LuceneQueryParsingResult)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
            if (parsingResult == null) {
                parsingResult = (LuceneQueryParsingResult)this.queryParser.parseQuery(jpqlString, (AstProcessingChain)this.makeProcessingChain());
                this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, parsingResult);
            }
        } else {
            parsingResult = (LuceneQueryParsingResult)this.queryParser.parseQuery(jpqlString, (AstProcessingChain)this.makeProcessingChain());
        }
        return parsingResult;
    }

    protected LuceneProcessingChain makeProcessingChain() {
        final EntityNamesResolver entityNamesResolver = new EntityNamesResolver(){

            public Class<?> getClassFromName(String entityName) {
                try {
                    return Util.loadClassStrict((String)entityName, null);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        };
        FieldBridgeProvider fieldBridgeProvider = new FieldBridgeProvider(){
            private final ClassBasedLucenePropertyHelper propertyHelper;
            {
                this.propertyHelper = new ClassBasedLucenePropertyHelper(QueryEngine.this.searchFactory, entityNamesResolver);
            }

            public FieldBridge getFieldBridge(String type, String propertyPath) {
                return this.propertyHelper.getFieldBridge(type, Arrays.asList(propertyPath.split("[.]")));
            }
        };
        return new LuceneProcessingChain.Builder(this.searchFactory, entityNamesResolver).buildProcessingChainForClassBasedEntities(fieldBridgeProvider);
    }
}

