/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.massindex.IndexUpdater;

public class IndexWorker
implements DistributedCallable<Object, Object, Object> {
    protected Cache<Object, Object> cache;
    protected final Class<?> entity;
    private final boolean flush;
    protected IndexUpdater indexUpdater;
    private ClusteringDependentLogic clusteringDependentLogic;

    public IndexWorker(Class<?> entity, boolean flush) {
        this.entity = entity;
        this.flush = flush;
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        this.cache = cache;
        this.indexUpdater = new IndexUpdater(cache);
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        this.clusteringDependentLogic = (ClusteringDependentLogic)componentRegistry.getComponent(ClusteringDependentLogic.class);
    }

    protected void preIndex() {
        if (this.flush) {
            this.indexUpdater.purge(this.entity);
        }
    }

    protected void postIndex() {
        if (this.flush) {
            this.indexUpdater.flush(this.entity);
        }
    }

    private KeyValueFilter getFilter() {
        boolean replicated = this.cache.getCacheConfiguration().clustering().cacheMode().isReplicated();
        return replicated ? AcceptAllKeyValueFilter.getInstance() : new PrimaryOwnersKeyValueFilter();
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public Void call() throws Exception {
        this.preIndex();
        KeyValueFilter filter = this.getFilter();
        try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).cacheEntrySet().stream();){
            Iterator iterator = stream.filter(CacheFilters.predicate((KeyValueFilter)filter)).iterator();
            while (iterator.hasNext()) {
                CacheEntry next = (CacheEntry)iterator.next();
                Object value = this.extractValue(next.getValue());
                if (value == null || !value.getClass().equals(this.entity)) continue;
                this.indexUpdater.updateIndex(next.getKey(), value);
            }
        }
        this.postIndex();
        return null;
    }

    public static class Externalizer
    extends AbstractExternalizer<IndexWorker> {
        public Set<Class<? extends IndexWorker>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{IndexWorker.class});
        }

        public void writeObject(ObjectOutput output, IndexWorker worker) throws IOException {
            output.writeObject(worker.entity);
            output.writeBoolean(worker.flush);
        }

        public IndexWorker readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new IndexWorker((Class)input.readObject(), input.readBoolean());
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_WORKER;
        }
    }

    private class PrimaryOwnersKeyValueFilter
    implements KeyValueFilter {
        private PrimaryOwnersKeyValueFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return IndexWorker.this.clusteringDependentLogic.localNodeIsPrimaryOwner(key);
        }
    }
}

